/*
 * Decompiled with CFR 0.152.
 */
package rustic.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.items.ItemFluidBottle;
import rustic.common.items.ModItems;
import rustic.common.util.GenericUtil;

public class EventHandlerCommon {
    private Random rand = new Random();
    public static Map<BlockPos, TileEntity> toUpdate = new HashMap<BlockPos, TileEntity>();

    public static void markTEForUpdate(BlockPos pos, TileEntity tile) {
        if (!toUpdate.containsKey(pos)) {
            toUpdate.put(pos, tile);
        } else {
            toUpdate.replace(pos, tile);
        }
    }

    @SubscribeEvent
    public void onOliveOilCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player != null && !event.crafting.func_190926_b() && event.crafting.func_77973_b() instanceof ItemFood && event.crafting.func_77942_o() && event.crafting.func_77978_p().func_74764_b("oiled") && !event.player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
            event.player.func_71019_a(new ItemStack(Items.field_151069_bo), false);
        }
    }

    @SubscribeEvent
    public void onVineDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150395_bd && this.rand.nextInt(20) == 0) {
            try {
                event.getDrops().add(new ItemStack((Block)ModBlocks.GRAPE_STEM));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onItemUseTick(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entityLiving;
        ItemStack originalStack = event.getItem();
        if (!originalStack.func_190926_b() && originalStack.func_77973_b() instanceof ItemSoup && originalStack.func_77942_o() && originalStack.func_77978_p().func_74764_b("oiled") && (entityLiving = event.getEntityLiving()) instanceof EntityPlayer && event.getDuration() == 1) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(2, 0.3f);
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entityLiving;
        ItemStack originalStack = event.getItem();
        if (!originalStack.func_190926_b() && originalStack.func_77973_b() instanceof ItemFood && originalStack.func_77942_o() && originalStack.func_77978_p().func_74764_b("oiled") && (entityLiving = event.getEntityLiving()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(2, 0.3f);
        }
    }

    @SubscribeEvent
    public void onFoodTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFood && stack.func_77942_o() && stack.func_77978_p().func_74764_b("oiled")) {
            event.getToolTip().add(TextFormatting.DARK_GREEN + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.rustic.olive_oil", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onBoozeTooltip(ItemTooltipEvent event) {
        FluidStack fluid;
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFluidContainer && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null && fluid.getFluid() != null && fluid.getFluid() instanceof FluidBooze && fluid.tag != null && fluid.tag.func_150297_b("Quality", 5)) {
            float quality = fluid.tag.func_74760_g("Quality");
            event.getToolTip().add(TextFormatting.GOLD + "" + I18n.func_135052_a((String)"tooltip.rustic.quality", (Object[])new Object[0]) + quality);
        }
    }

    @SubscribeEvent
    public void onPlayerUseGlassBottle(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b().equals(Items.field_151069_bo)) {
            EntityPlayer player = event.getEntityPlayer();
            BlockPos pos = event.getPos();
            ItemStack stack = event.getItemStack();
            World world = event.getWorld();
            RayTraceResult raytraceresult = GenericUtil.rayTrace(world, player, true);
            BlockPos pos2 = raytraceresult.func_178782_a();
            if (player.func_175151_a(pos2, event.getFace(), stack) && player.func_175151_a(pos2.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, stack)) {
                IFluidHandler tank;
                IBlockState state = world.func_180495_p(pos2);
                if (state.func_177230_c() instanceof IFluidBlock) {
                    IFluidBlock fluidblock = (IFluidBlock)state.func_177230_c();
                    if (ItemFluidBottle.VALID_FLUIDS.contains(fluidblock.getFluid()) && fluidblock.getFilledPercentage(world, pos2) == 1.0f) {
                        world.func_180501_a(pos2, Blocks.field_150350_a.func_176223_P(), 11);
                        player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                        player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottlestack = new ItemStack((Item)ModItems.FLUID_BOTTLE, 1);
                        NBTTagCompound fluidTag = new FluidStack(fluidblock.getFluid(), 1000).writeToNBT(new NBTTagCompound());
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
                        bottlestack.func_77982_d(tag);
                        if (!player.field_71071_by.func_70441_a(bottlestack)) {
                            player.func_71019_a(bottlestack, false);
                        }
                    }
                } else if (state.func_177230_c() instanceof ITileEntityProvider && world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace()) && (tank = (IFluidHandler)world.func_175625_s(pos).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace())) != null && tank.drain(1000, false) != null && tank.drain(1000, false).getFluid() != null) {
                    if (ItemFluidBottle.VALID_FLUIDS.contains(tank.drain(1000, false).getFluid()) && tank.drain((int)1000, (boolean)false).amount >= 1000) {
                        FluidStack fill = tank.drain(1000, true);
                        player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                        player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottlestack = new ItemStack((Item)ModItems.FLUID_BOTTLE, 1);
                        NBTTagCompound fluidTag = new FluidStack(fill.getFluid(), 1000).writeToNBT(new NBTTagCompound());
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74782_a("Fluid", (NBTBase)fluidTag);
                        bottlestack.func_77982_d(tag);
                        if (!player.field_71071_by.func_70441_a(bottlestack)) {
                            player.func_71019_a(bottlestack, false);
                        }
                        event.setCanceled(true);
                    } else if (tank.drain(1000, false).getFluid() == FluidRegistry.WATER) {
                        FluidStack fill = tank.drain(1000, true);
                        player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                        player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        ItemStack bottlestack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                        if (!player.field_71071_by.func_70441_a(bottlestack)) {
                            player.func_71019_a(bottlestack, false);
                        }
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

