/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.BlockChain;
import rustic.common.blocks.BlockLantern;

public class BlockLattice
extends BlockBase {
    public static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.5625, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 1.0, 0.5625, 0.5625, 0.5625);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.4375, 0.5625, 0.5625);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.4375, 0.5625, 0.4375, 0.5625, 1.0, 0.5625);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.4375, 0.5625);
    public static final PropertyBool N = PropertyBool.func_177716_a((String)"n");
    public static final PropertyBool E = PropertyBool.func_177716_a((String)"e");
    public static final PropertyBool S = PropertyBool.func_177716_a((String)"s");
    public static final PropertyBool W = PropertyBool.func_177716_a((String)"w");
    public static final PropertyBool U = PropertyBool.func_177716_a((String)"u");
    public static final PropertyBool D = PropertyBool.func_177716_a((String)"d");
    public static final PropertyBool LEAVES = PropertyBool.func_177716_a((String)"leaves");
    public static final PropertyBool LEAVES_NORTH = PropertyBool.func_177716_a((String)"leaves_north");
    public static final PropertyBool LEAVES_EAST = PropertyBool.func_177716_a((String)"leaves_east");
    public static final PropertyBool LEAVES_SOUTH = PropertyBool.func_177716_a((String)"leaves_south");
    public static final PropertyBool LEAVES_WEST = PropertyBool.func_177716_a((String)"leaves_west");
    public static final PropertyBool LEAVES_UP = PropertyBool.func_177716_a((String)"leaves_up");
    public static final PropertyBool LEAVES_DOWN = PropertyBool.func_177716_a((String)"leaves_down");

    public BlockLattice(Material mat, String name) {
        super(mat, name);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        if (((Boolean)state.func_177229_b((IProperty)N)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)E)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)S)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)W)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)U)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)D)).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double x1 = 0.375;
        double y1 = 0.375;
        double z1 = 0.375;
        double x2 = 0.625;
        double y2 = 0.625;
        double z2 = 0.625;
        if (((Boolean)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)U)).booleanValue()) {
            y2 = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)D)).booleanValue()) {
            y1 = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)N)).booleanValue()) {
            z1 = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)S)).booleanValue()) {
            z2 = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)W)).booleanValue()) {
            x1 = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)E)).booleanValue()) {
            x2 = 1.0;
        }
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (Block.func_149634_a((Item)heldItem.func_77973_b()) != null && Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockLeaves) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(true)));
            playerIn.func_184586_b(hand).func_190918_g(1);
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LEAVES) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = meta == 0 ? iblockstate.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(true));
        return iblockstate;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState stateTemp = worldIn.func_180495_p(pos.func_177978_c());
        Block blockTemp = stateTemp.func_177230_c();
        boolean nSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.SOUTH) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.Z;
        stateTemp = worldIn.func_180495_p(pos.func_177974_f());
        blockTemp = stateTemp.func_177230_c();
        boolean eSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.WEST) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.X;
        stateTemp = worldIn.func_180495_p(pos.func_177968_d());
        blockTemp = stateTemp.func_177230_c();
        boolean sSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.NORTH) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.Z;
        stateTemp = worldIn.func_180495_p(pos.func_177976_e());
        blockTemp = stateTemp.func_177230_c();
        boolean wSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.EAST) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.X;
        stateTemp = worldIn.func_180495_p(pos.func_177984_a());
        blockTemp = stateTemp.func_177230_c();
        boolean uSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.DOWN) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.Y || blockTemp instanceof BlockLantern;
        stateTemp = worldIn.func_180495_p(pos.func_177977_b());
        blockTemp = stateTemp.func_177230_c();
        boolean dSolid = blockTemp.isSideSolid(stateTemp, worldIn, pos, EnumFacing.UP) || blockTemp instanceof BlockLattice || blockTemp instanceof BlockChain && stateTemp.func_177229_b(BlockChain.AXIS) == EnumFacing.Axis.Y || blockTemp instanceof BlockLantern;
        boolean leaves = (Boolean)state.func_177229_b((IProperty)LEAVES);
        return state.func_177226_a((IProperty)N, (Comparable)Boolean.valueOf(nSolid)).func_177226_a((IProperty)LEAVES_NORTH, (Comparable)Boolean.valueOf(nSolid && leaves)).func_177226_a((IProperty)E, (Comparable)Boolean.valueOf(eSolid)).func_177226_a((IProperty)LEAVES_EAST, (Comparable)Boolean.valueOf(eSolid && leaves)).func_177226_a((IProperty)S, (Comparable)Boolean.valueOf(sSolid)).func_177226_a((IProperty)LEAVES_SOUTH, (Comparable)Boolean.valueOf(sSolid && leaves)).func_177226_a((IProperty)W, (Comparable)Boolean.valueOf(wSolid)).func_177226_a((IProperty)LEAVES_WEST, (Comparable)Boolean.valueOf(wSolid && leaves)).func_177226_a((IProperty)U, (Comparable)Boolean.valueOf(uSolid)).func_177226_a((IProperty)LEAVES_UP, (Comparable)Boolean.valueOf(uSolid && leaves)).func_177226_a((IProperty)D, (Comparable)Boolean.valueOf(dSolid)).func_177226_a((IProperty)LEAVES_DOWN, (Comparable)Boolean.valueOf(dSolid && leaves));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{N, E, S, W, U, D, LEAVES, LEAVES_NORTH, LEAVES_EAST, LEAVES_SOUTH, LEAVES_WEST, LEAVES_UP, LEAVES_DOWN});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)N, state.func_177229_b((IProperty)S)).func_177226_a((IProperty)E, state.func_177229_b((IProperty)W)).func_177226_a((IProperty)S, state.func_177229_b((IProperty)N)).func_177226_a((IProperty)W, state.func_177229_b((IProperty)E));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)N, state.func_177229_b((IProperty)E)).func_177226_a((IProperty)E, state.func_177229_b((IProperty)S)).func_177226_a((IProperty)S, state.func_177229_b((IProperty)W)).func_177226_a((IProperty)W, state.func_177229_b((IProperty)N));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)N, state.func_177229_b((IProperty)W)).func_177226_a((IProperty)E, state.func_177229_b((IProperty)N)).func_177226_a((IProperty)S, state.func_177229_b((IProperty)E)).func_177226_a((IProperty)W, state.func_177229_b((IProperty)S));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)N, state.func_177229_b((IProperty)S)).func_177226_a((IProperty)S, state.func_177229_b((IProperty)N));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)E, state.func_177229_b((IProperty)W)).func_177226_a((IProperty)W, state.func_177229_b((IProperty)E));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }
}

