/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.renderer.LiquidBarrelRenderer;
import rustic.common.blocks.BlockBase;
import rustic.common.tileentity.TileEntityLiquidBarrel;

public class BlockLiquidBarrel
extends BlockBase
implements ITileEntityProvider {
    protected static final AxisAlignedBB BARREL_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockLiquidBarrel() {
        super(Material.field_151575_d, "liquid_barrel");
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("FluidName", 8) && nbttagcompound.func_150297_b("Amount", 3)) {
            Fluid fluid = FluidRegistry.getFluid((String)nbttagcompound.func_74779_i("FluidName"));
            int amount = nbttagcompound.func_74762_e("Amount");
            FluidStack fluidStack = new FluidStack(fluid, amount);
            tooltip.add(amount + "mb of " + fluid.getLocalizedName(fluidStack));
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLiquidBarrel();
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ((TileEntityLiquidBarrel)world.func_175625_s(pos)).breakBlock(world, pos, state, player);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((TileEntityLiquidBarrel)world.func_175625_s(pos)).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        return items;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (stack.func_77942_o()) {
            TileEntityLiquidBarrel tile = (TileEntityLiquidBarrel)this.func_149915_a(world, this.func_176201_c(state));
            world.func_175690_a(pos, (TileEntity)tile);
            tile.getTank().readFromNBT(stack.func_77978_p());
            tile.func_70296_d();
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BARREL_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLiquidBarrel.class, (TileEntitySpecialRenderer)new LiquidBarrelRenderer());
    }
}

