/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.BlockGrapeLeaves;

public class BlockRope
extends BlockBase {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyBool DANGLE = PropertyBool.func_177716_a((String)"dangle");
    public static final PropertyBool SUPPORTED = PropertyBool.func_177716_a((String)"supported");
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 1.0);
    protected static final AxisAlignedBB X_DANGLE_AABB = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 0.5625, 0.5625);
    protected static final AxisAlignedBB Z_DANGLE_AABB = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 0.5625, 1.0);

    public BlockRope(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(false)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 20, 60);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_176198_a(world, pos.func_177972_a(side), side) && stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            int yOffset;
            for (yOffset = 1; yOffset < 64 && world.func_180495_p(pos.func_177979_c(yOffset)).func_177230_c() == this; ++yOffset) {
                if (world.func_180495_p(pos.func_177979_c(yOffset)).func_177229_b(AXIS) == EnumFacing.Axis.Y) continue;
                return false;
            }
            if (this.func_176196_c(world, pos.func_177979_c(yOffset))) {
                world.func_180501_a(pos.func_177979_c(yOffset), state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y), 3);
                player.func_184586_b(hand).func_190918_g(1);
                SoundType soundType = this.getSoundType(state, world, pos, (Entity)player);
                world.func_184134_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() - yOffset), (double)pos.func_177952_p(), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                return true;
            }
        }
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos blockPos = pos.func_177972_a(side.func_176734_d());
        if (side == EnumFacing.UP && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            return false;
        }
        if (world.func_180495_p(blockPos).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(blockPos).func_177229_b(AXIS) == side.func_176740_k()) {
            return true;
        }
        if (world.func_180495_p(blockPos).func_177230_c() == ModBlocks.GRAPE_LEAVES && world.func_180495_p(blockPos).func_177229_b(BlockGrapeLeaves.AXIS) == side.func_176740_k()) {
            return true;
        }
        if (world.func_180495_p(blockPos).func_177230_c() == ModBlocks.STAKE_TIED) {
            return true;
        }
        return world.isSideSolid(blockPos, side);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            SoundType soundType = this.getSoundType(state, worldIn, pos, null);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, true);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        boolean supported = this.isSupported(state, worldIn, pos);
        if (supported != (Boolean)state.func_177229_b((IProperty)SUPPORTED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(supported)), 3);
        }
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        boolean canStay = (Boolean)state.func_177229_b((IProperty)SUPPORTED);
        if (!canStay) {
            boolean flag = false;
            boolean flag1 = false;
            if (state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
                if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockRope || world.func_180495_p(pos.func_177984_a()).func_177230_c() == ModBlocks.GRAPE_LEAVES) {
                    canStay = true;
                }
            } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                IBlockState state1 = world.func_180495_p(pos.func_177978_c());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                    flag = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(BlockGrapeLeaves.AXIS) == EnumFacing.Axis.Z) {
                    flag = true;
                }
                state1 = world.func_180495_p(pos.func_177968_d());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                    flag1 = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(BlockGrapeLeaves.AXIS) == EnumFacing.Axis.Z) {
                    flag1 = true;
                }
                canStay = flag && flag1;
            } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                IBlockState state1 = world.func_180495_p(pos.func_177976_e());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                    flag = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(BlockGrapeLeaves.AXIS) == EnumFacing.Axis.X) {
                    flag = true;
                }
                state1 = world.func_180495_p(pos.func_177974_f());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                    flag1 = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(BlockGrapeLeaves.AXIS) == EnumFacing.Axis.X) {
                    flag1 = true;
                }
                canStay = flag && flag1;
            }
        }
        return canStay;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, DANGLE, SUPPORTED});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Y;
        boolean supported = false;
        int i = meta & 3;
        if (i == 0) {
            enumfacing$axis = EnumFacing.Axis.Y;
        } else if (i == 1) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 2) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        i = meta & 4;
        if (i > 0) {
            supported = true;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)enumfacing$axis).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i = 1;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i = 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)SUPPORTED)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(AXIS) != EnumFacing.Axis.Y && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRope && world.func_180495_p(pos.func_177977_b()).func_177229_b(AXIS) == EnumFacing.Axis.Y) {
            return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean supported = false;
        BlockPos blockPos = pos.func_177972_a(facing.func_176734_d());
        if (worldIn.isSideSolid(blockPos, facing)) {
            supported = true;
        } else if (worldIn.func_180495_p(blockPos).func_177230_c() == ModBlocks.STAKE_TIED) {
            supported = true;
        }
        blockPos = pos.func_177972_a(facing);
        if (worldIn.isSideSolid(blockPos, facing.func_176734_d())) {
            supported = true;
        } else if (worldIn.func_180495_p(blockPos).func_177230_c() == ModBlocks.STAKE_TIED) {
            supported = true;
        }
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(AXIS, (Comparable)facing.func_176740_k()).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(supported));
    }

    public boolean isSupported(IBlockState state, World world, BlockPos pos) {
        boolean supported = false;
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
            supported = world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN);
        } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            if (world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH) || world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
            if (world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH) || world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
        } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
            if (world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST) || world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
            if (world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST) || world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
        }
        return supported;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{SUPPORTED}).func_178441_a());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case Y: {
                return Y_AABB;
            }
            case X: {
                if (((Boolean)state.func_177229_b((IProperty)DANGLE)).booleanValue()) {
                    return X_DANGLE_AABB;
                }
                return X_AABB;
            }
            case Z: {
                if (((Boolean)state.func_177229_b((IProperty)DANGLE)).booleanValue()) {
                    return Z_DANGLE_AABB;
                }
                return Z_AABB;
            }
        }
        return Y_AABB;
    }
}

