/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.crops;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.BlockRope;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.BlockGrapeStem;
import rustic.common.items.ModItems;
import rustic.core.ClientProxy;
import rustic.core.Rustic;

public class BlockGrapeLeaves
extends BlockBase
implements IGrowable,
IColoredBlock {
    public static final PropertyBool GRAPES = PropertyBool.func_177716_a((String)"grapes");
    public static final PropertyInteger DIST = PropertyInteger.func_177719_a((String)"distance", (int)0, (int)1);
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177708_a((String)"axis", EnumFacing.Axis.class, (Predicate)new Predicate<EnumFacing.Axis>(){

        public boolean apply(@Nullable EnumFacing.Axis p_apply_1_) {
            return p_apply_1_ != EnumFacing.Axis.Y;
        }
    });
    public static final PropertyBool DANGLE = PropertyBool.func_177716_a((String)"dangle");
    public static final PropertyBool SUPPORTED = PropertyBool.func_177716_a((String)"supported");
    public static final AxisAlignedBB BRANCH_Z_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);
    public static final AxisAlignedBB BRANCH_X_AABB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);

    public BlockGrapeLeaves() {
        super(Material.field_151584_j, "grape_leaves", false);
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_149675_a(true);
        this.func_149647_a(Rustic.farmingTab);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X).func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(0)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            stacks.add(new ItemStack((Item)ModItems.GRAPES));
        }
        return stacks;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        boolean supported = (Boolean)state.func_177229_b((IProperty)SUPPORTED);
        super.func_180663_b(world, pos, state);
        world.func_180501_a(pos, ModBlocks.ROPE.func_176223_P().func_177226_a(BlockRope.AXIS, (Comparable)axis).func_177226_a((IProperty)BlockRope.SUPPORTED, (Comparable)Boolean.valueOf(supported)), 3);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false)), 3);
            state.func_177230_c();
            Block.func_180635_a((World)world, (BlockPos)pos.func_177972_a(side), (ItemStack)new ItemStack((Item)ModItems.GRAPES, world.field_73012_v.nextInt(2) + 1));
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        boolean supported = this.isSupported(state, worldIn, pos);
        if (supported != (Boolean)state.func_177229_b((IProperty)SUPPORTED)) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(supported)), 3);
        }
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            SoundType soundType = this.getSoundType(state, worldIn, pos, null);
            worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, true);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        boolean canStay = (Boolean)state.func_177229_b((IProperty)SUPPORTED);
        if (!canStay) {
            boolean flag = false;
            boolean flag1 = false;
            if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                IBlockState state1 = world.func_180495_p(pos.func_177978_c());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(BlockRope.AXIS) == EnumFacing.Axis.Z) {
                    flag = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                    flag = true;
                }
                state1 = world.func_180495_p(pos.func_177968_d());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(BlockRope.AXIS) == EnumFacing.Axis.Z) {
                    flag1 = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
                    flag1 = true;
                }
                canStay = flag && flag1;
            } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                IBlockState state1 = world.func_180495_p(pos.func_177976_e());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(BlockRope.AXIS) == EnumFacing.Axis.X) {
                    flag = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                    flag = true;
                }
                state1 = world.func_180495_p(pos.func_177974_f());
                if (state1.func_177230_c() == ModBlocks.ROPE && state1.func_177229_b(BlockRope.AXIS) == EnumFacing.Axis.X) {
                    flag1 = true;
                } else if (state1.func_177230_c() == ModBlocks.GRAPE_LEAVES && state1.func_177229_b(AXIS) == EnumFacing.Axis.X) {
                    flag1 = true;
                }
                boolean bl = canStay = flag && flag1;
            }
        }
        if ((Integer)state.func_177229_b((IProperty)DIST) == 1) {
            switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                case X: {
                    return canStay && (world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.GRAPE_LEAVES && (Integer)world.func_180495_p(pos.func_177976_e()).func_177229_b((IProperty)DIST) == 0 || world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.GRAPE_LEAVES && (Integer)world.func_180495_p(pos.func_177974_f()).func_177229_b((IProperty)DIST) == 0);
                }
                case Z: {
                    return canStay && (world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.GRAPE_LEAVES && (Integer)world.func_180495_p(pos.func_177978_c()).func_177229_b((IProperty)DIST) == 0 || world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.GRAPE_LEAVES && (Integer)world.func_180495_p(pos.func_177968_d()).func_177229_b((IProperty)DIST) == 0);
                }
            }
        }
        return canStay && world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.GRAPE_STEM && (Integer)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockGrapeStem.AGE) > 2;
    }

    public boolean isSupported(IBlockState state, World world, BlockPos pos) {
        boolean supported = false;
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            if (world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH) || world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
            if (world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH) || world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
        } else if (state.func_177229_b(AXIS) == EnumFacing.Axis.X) {
            if (world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST) || world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
            if (world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST) || world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.STAKE_TIED) {
                supported = true;
            }
        }
        return supported;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)DIST) < 1) {
            return Block.field_185505_j;
        }
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Z) {
            return BRANCH_Z_AABB;
        }
        return BRANCH_X_AABB;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ModItems.GRAPES);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            float f;
            int i = (Integer)state.func_177229_b((IProperty)DIST);
            if (i > 0 && !((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue() && worldIn.func_175623_d(pos.func_177977_b())) {
                float f2 = BlockGrapeLeaves.getGrowthChance(this, worldIn, pos);
                if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / f2) + 1) == 0 ? 1 : 0) != 0)) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(true)), 3);
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                }
            } else if (i < 1 && this.canSpread(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = BlockGrapeLeaves.getGrowthChance(this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
                this.spread(worldIn, pos, state);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        return 3.0f;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        if ((Integer)state.func_177229_b((IProperty)DIST) > 0) {
            return (Boolean)state.func_177229_b((IProperty)GRAPES) == false && worldIn.func_175623_d(pos.func_177977_b());
        }
        return this.canSpread(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) > 0) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.spread(worldIn, pos, state);
        }
    }

    public boolean canSpread(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) == 0) {
            switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                case X: {
                    return world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177976_e()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS) || world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177974_f()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                }
                case Z: {
                    return world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177978_c()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS) || world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177968_d()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                }
            }
        }
        return false;
    }

    public void spread(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)DIST) < 1) {
            switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                case X: {
                    boolean eastRope;
                    boolean westRope = world.func_180495_p(pos.func_177976_e()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177976_e()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                    boolean bl = eastRope = world.func_180495_p(pos.func_177974_f()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177974_f()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                    if (westRope && eastRope) {
                        this.spreadToValidRope(world, pos, (double)world.field_73012_v.nextFloat() < 0.5 ? pos.func_177976_e() : pos.func_177974_f(), state);
                        break;
                    }
                    if (westRope) {
                        this.spreadToValidRope(world, pos, pos.func_177976_e(), state);
                        break;
                    }
                    if (!eastRope) break;
                    this.spreadToValidRope(world, pos, pos.func_177974_f(), state);
                    break;
                }
                case Z: {
                    boolean southRope;
                    boolean northRope = world.func_180495_p(pos.func_177978_c()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177978_c()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                    boolean bl = southRope = world.func_180495_p(pos.func_177968_d()).func_177230_c() == ModBlocks.ROPE && world.func_180495_p(pos.func_177968_d()).func_177229_b(BlockRope.AXIS) == state.func_177229_b(AXIS);
                    if (northRope && southRope) {
                        this.spreadToValidRope(world, pos, (double)world.field_73012_v.nextFloat() < 0.5 ? pos.func_177978_c() : pos.func_177968_d(), state);
                        break;
                    }
                    if (northRope) {
                        this.spreadToValidRope(world, pos, pos.func_177978_c(), state);
                        break;
                    }
                    if (!southRope) break;
                    this.spreadToValidRope(world, pos, pos.func_177968_d(), state);
                }
            }
        }
    }

    private void spreadToValidRope(World world, BlockPos origPos, BlockPos newPos, IBlockState state) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(newPos).func_177229_b(BlockRope.AXIS);
        boolean supported = (Boolean)world.func_180495_p(newPos).func_177229_b((IProperty)BlockRope.SUPPORTED);
        world.func_180501_a(newPos, this.func_176223_P().func_177226_a(AXIS, (Comparable)axis).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(supported)).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(1)), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, DANGLE, SUPPORTED, DIST, GRAPES});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.X;
        boolean supported = false;
        int dist = 0;
        boolean grapes = false;
        int i = meta & 1;
        if (i == 0) {
            enumfacing$axis = EnumFacing.Axis.X;
        } else if (i == 1) {
            enumfacing$axis = EnumFacing.Axis.Z;
        }
        i = meta & 2;
        if (i > 0) {
            dist = 1;
        }
        if ((i = meta & 4) > 0) {
            supported = true;
        }
        if ((i = meta & 8) > 0) {
            grapes = true;
        }
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)enumfacing$axis).func_177226_a((IProperty)DIST, (Comparable)Integer.valueOf(dist)).func_177226_a((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(grapes));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis enumfacing$axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (enumfacing$axis == EnumFacing.Axis.X) {
            i = 0;
        } else if (enumfacing$axis == EnumFacing.Axis.Z) {
            i = 1;
        }
        if ((Integer)state.func_177229_b((IProperty)DIST) == 1) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)SUPPORTED)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRope && world.func_180495_p(pos.func_177977_b()).func_177229_b(BlockRope.AXIS) == EnumFacing.Axis.Y) {
            return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)DANGLE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{SUPPORTED}).func_178441_a());
        ClientProxy.addColoredBlock(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }
}

