/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks.fluids;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.fluids.FluidStateMapper;

public class BlockFluidRustic
extends BlockFluidClassic {
    public BlockFluidRustic(String name, Fluid fluid, Material material) {
        super(fluid, material);
        this.setRegistryName(name);
        this.func_149663_c("rustic." + name);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        fluid.setBlock((Block)this);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176212_b(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        Item item = Item.func_150898_a((Block)this);
        FluidStateMapper stateMapper = new FluidStateMapper(this.stack.getFluid());
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("rustic:block_fluid", this.stack.getFluid().getName());
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)stateMapper);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMapper);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState neighbor = world.func_180495_p(pos.func_177972_a(side));
        return neighbor.func_177230_c() != state.func_177230_c();
    }

    protected boolean canFlowInto(IBlockAccess world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return true;
        }
        if (this.displacements.containsKey(state.func_177230_c())) {
            return (Boolean)this.displacements.get(state.func_177230_c());
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockFluidBase) {
            return false;
        }
        int density = BlockFluidRustic.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 1.0f) {
                return 1.0f;
            }
            if (flow[i] >= 0.875f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            return false;
        }
        if (block instanceof BlockFluidBase && (Integer)state.func_177229_b((IProperty)LEVEL) == 0) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                if (state.func_177230_c() != Blocks.field_150431_aC) {
                    block.func_176226_b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockFluidRustic.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            block.func_176226_b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }
}

