/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.items;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import rustic.common.blocks.crops.BlockHerbBase;
import rustic.core.Rustic;

public class ItemHerbEdible
extends ItemFood
implements IPlantable {
    private BlockHerbBase herbBlock;

    public ItemHerbEdible(BlockHerbBase herbBlock, int hunger, float saturation) {
        super(hunger, saturation, false);
        this.herbBlock = herbBlock;
        this.setRegistryName(herbBlock.getRegistryName());
        this.func_77655_b(herbBlock.func_149739_a());
        this.func_77637_a(Rustic.alchemyTab);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.herbBlock.func_176223_P());
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.herbBlock.getPlantType(world, pos);
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.herbBlock.func_176223_P();
    }
}

