/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import rustic.common.blocks.BlockCabinet;
import rustic.common.blocks.ModBlocks;
import rustic.common.inventory.DoubleCabinetItemHandler;
import rustic.common.tileentity.ContainerCabinet;
import rustic.common.tileentity.ContainerCabinetDouble;
import rustic.common.util.ItemStackHandlerRustic;
import vazkii.quark.base.handler.IDropoffManager;

public class TileEntityCabinet
extends TileEntityLockableLoot
implements ITickable,
IDropoffManager {
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    public int numPlayersUsing = 0;
    private int ticksSinceSync = 0;
    private ItemStackHandlerRustic itemStackHandler = new ItemStackHandlerRustic(27){

        protected void onContentsChanged(int slot) {
            TileEntityCabinet.this.func_70296_d();
        }
    };
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;
    public DoubleCabinetItemHandler doubleCabinetHandler;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == ModBlocks.CABINET && this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177227_a().contains(BlockCabinet.TOP) && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 1.0);
        }
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 1.0);
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            int recordedUsers = this.numPlayersUsing;
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                TileEntityCabinet tec;
                if (entityplayer.field_71070_bA instanceof ContainerCabinet) {
                    tec = ((ContainerCabinet)entityplayer.field_71070_bA).getTile();
                    if (!tec.equals(this)) continue;
                    ++this.numPlayersUsing;
                    continue;
                }
                if (!(entityplayer.field_71070_bA instanceof ContainerCabinetDouble) || !(tec = ((ContainerCabinetDouble)entityplayer.field_71070_bA).getTileBottom()).equals(this)) continue;
                ++this.numPlayersUsing;
            }
            if (this.numPlayersUsing != recordedUsers) {
                this.func_70296_d();
            }
        }
        this.prevLidAngle = this.lidAngle;
        float f1 = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockCabinet) {
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!this.func_184283_b(compound) && compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.func_190575_a(compound.func_74779_i("CustomName"));
        }
        if (compound.func_74764_b("numUsers")) {
            this.numPlayersUsing = compound.func_74762_e("numUsers");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        compound.func_74782_a("numUsers", (NBTBase)new NBTTagInt(this.numPlayersUsing));
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.func_145831_w().field_72995_K) {
                this.func_184281_d(null);
            }
            if (this.doubleCabinetHandler == null || this.doubleCabinetHandler.needsRefresh()) {
                this.doubleCabinetHandler = DoubleCabinetItemHandler.get(this);
            }
            if (this.doubleCabinetHandler != null && this.doubleCabinetHandler != DoubleCabinetItemHandler.NO_ADJACENT_CABINETS_INSTANCE) {
                if (!this.func_145831_w().field_72995_K) {
                    this.doubleCabinetHandler.getOtherCabinet().func_184281_d(null);
                }
                return (T)this.doubleCabinetHandler;
            }
            return (T)((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getSingleCabinetHandler() {
        return this.itemStackHandler;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.doubleCabinetHandler = null;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.func_145843_s();
        if (this.itemStackHandler != null && !world.field_72995_K) {
            this.func_184281_d(null);
            for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                if (this.itemStackHandler.getStackInSlot(i) == null) continue;
                state.func_177230_c();
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.itemStackHandler.getStackInSlot(i));
            }
        }
        world.func_175690_a(pos, null);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int func_70302_i_() {
        return this.itemStackHandler.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            if (this.itemStackHandler.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        this.func_184281_d(null);
        return this.itemStackHandler.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return this.itemStackHandler.extractItem(index, count, false);
    }

    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        ItemStack stack = this.itemStackHandler.getStackInSlot(index);
        this.itemStackHandler.setStackInSlot(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.itemStackHandler.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.func_184281_d(null);
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            this.itemStackHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.rustic.cabinet";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        if (!this.field_145850_b.field_72995_K) {
            this.func_184281_d(playerIn);
        }
        if (((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                ((TileEntityCabinet)this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())).func_184281_d(playerIn);
            }
            return new ContainerCabinetDouble((IInventory)playerInventory, this, (TileEntityCabinet)this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b()), playerIn);
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() instanceof BlockCabinet && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177229_b((IProperty)BlockCabinet.TOP)).booleanValue()) {
            if (!this.field_145850_b.field_72995_K) {
                ((TileEntityCabinet)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())).func_184281_d(playerIn);
            }
            return new ContainerCabinetDouble((IInventory)playerInventory, (TileEntityCabinet)this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a()), this, playerIn);
        }
        return new ContainerCabinet((IInventory)playerInventory, this, playerIn);
    }

    public String func_174875_k() {
        return "rustic:cabinet";
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.itemStackHandler.getStacks();
    }

    public void func_189404_a(ResourceLocation file, long seed) {
        super.func_189404_a(file, seed);
        this.func_70296_d();
    }

    @Override
    public boolean acceptsDropoff() {
        return true;
    }
}

