/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import rustic.common.crafting.AdvancedCondenserRecipe;
import rustic.common.crafting.BasicCondenserRecipe;
import rustic.common.crafting.CondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.common.util.ElixirUtils;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.Condenser")
public class Condenser {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2) {
        BasicCondenserRecipe r = new BasicCondenserRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toStack(input1), CraftTweakerHelper.toStack(input2));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack modifier, IItemStack[] inputs) {
        AdvancedCondenserRecipe r = new AdvancedCondenserRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toStack(modifier), CraftTweakerHelper.toStacks(inputs));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (CraftTweakerHelper.toStack(output) != ItemStack.field_190927_a) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toStack(output)));
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<CondenserRecipe> removedRecipes = new ArrayList<CondenserRecipe>();

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            List<PotionEffect> effects = ElixirUtils.getEffects(this.output);
            Iterator<CondenserRecipe> it = Recipes.condenserRecipes.iterator();
            while (it.hasNext()) {
                CondenserRecipe r = it.next();
                List<PotionEffect> rEffects = ElixirUtils.getEffects(r.getResult());
                if (r == null || r.getResult() == null || !r.getResult().func_77969_a(this.output) || !effects.equals(rEffects)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (CondenserRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    Recipes.condenserRecipes.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Condenser Recipes for Item " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Condenser Recipes for Item " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final CondenserRecipe recipe;

        public Add(CondenserRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.condenserRecipes.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Recipes.condenserRecipes.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Alchemy Recipe for Item " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Alchemy Recipe for Item " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

