/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.CrushingTub")
public class CrushingTub {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, IItemStack byproduct, IItemStack input) {
        CrushingTubRecipe r = new CrushingTubRecipe(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toStack(input), CraftTweakerHelper.toStack(byproduct));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack output, IItemStack input) {
        if (CraftTweakerHelper.toFluidStack(output) != null && CraftTweakerHelper.toStack(input) != ItemStack.field_190927_a) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFluid(CraftTweakerHelper.toFluidStack(output), CraftTweakerHelper.toStack(input)));
        }
    }

    private static class RemoveFluid
    implements IUndoableAction {
        private final FluidStack output;
        private final ItemStack input;
        List<CrushingTubRecipe> removedRecipes = new ArrayList<CrushingTubRecipe>();

        public RemoveFluid(FluidStack output, ItemStack input) {
            this.output = output;
            this.input = input;
        }

        public void apply() {
            Iterator<CrushingTubRecipe> it = Recipes.crushingTubRecipes.iterator();
            while (it.hasNext()) {
                CrushingTubRecipe r = it.next();
                if (r == null || r.getResult() == null || !r.getResult().isFluidEqual(this.output) || !r.getInput().func_77969_a(this.input)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (CrushingTubRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    Recipes.crushingTubRecipes.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Crushing Tub Recipes for Fluid " + this.output.getLocalizedName();
        }

        public String describeUndo() {
            return "Re-Adding Crushing Tub Recipes for Fluid " + this.output.getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final CrushingTubRecipe recipe;

        public Add(CrushingTubRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.crushingTubRecipes.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Recipes.crushingTubRecipes.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Crushing Tub Recipe for Fluid " + this.recipe.getResult().getLocalizedName();
        }

        public String describeUndo() {
            return "Removing Crushing Tub Recipe for Fluid " + this.recipe.getResult().getLocalizedName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

