/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.EvaporatingBasin")
public class EvaporatingBasin {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack input) {
        EvaporatingBasinRecipe r = new EvaporatingBasinRecipe(CraftTweakerHelper.toStack(output), CraftTweakerHelper.toFluidStack(input));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (CraftTweakerHelper.toStack(output) != ItemStack.field_190927_a) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(CraftTweakerHelper.toStack(output)));
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<EvaporatingBasinRecipe> removedRecipes = new ArrayList<EvaporatingBasinRecipe>();

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<EvaporatingBasinRecipe> it = Recipes.evaporatingRecipes.iterator();
            while (it.hasNext()) {
                EvaporatingBasinRecipe r = it.next();
                if (r == null || r.getResult() == null || !r.getResult().func_77969_a(this.output)) continue;
                this.removedRecipes.add(r);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)r);
                it.remove();
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (EvaporatingBasinRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    Recipes.evaporatingRecipes.add(recipe);
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)recipe);
                }
            }
        }

        public String describe() {
            return "Removing Evaporating Recipes for Item " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Evaporating Recipes for Item " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final EvaporatingBasinRecipe recipe;

        public Add(EvaporatingBasinRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.evaporatingRecipes.add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Recipes.evaporatingRecipes.remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Evaporating Recipe for Item " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Evaporating Recipe for Item " + this.recipe.getResult().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

