/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.automation;

import cd4017be.api.Capabilities;
import cd4017be.api.IAbstractTile;
import cd4017be.api.energy.EnergyAPI;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PipeEnergy
implements EnergyAPI.IEnergyAccess {
    public boolean update;
    public byte sideCfg;
    public float Ucap;
    public float[] Iind;
    public final int Umax;
    public final float Zcond;

    public PipeEnergy(int Umax, float Rcond) {
        this.Umax = Umax;
        this.Zcond = 1.0f + Rcond;
        this.sideCfg = (byte)63;
        this.Iind = new float[]{0.0f, 0.0f, 0.0f};
    }

    public PipeEnergy connect(byte c) {
        this.sideCfg = c;
        return this;
    }

    public float getEnergy(float U, float R) {
        if (R < 1.0f) {
            R = 1.0f;
        }
        return (this.Ucap * this.Ucap - U * U) / R;
    }

    @Override
    public float getStorage() {
        return this.Ucap * this.Ucap;
    }

    @Override
    public float getCapacity() {
        return (float)this.Umax * (float)this.Umax;
    }

    @Override
    public float addEnergy(float e) {
        float d = this.Ucap * this.Ucap;
        e += d;
        float m = (float)this.Umax * (float)this.Umax;
        if (e < 0.0f) {
            e = 0.0f;
            this.Ucap = 0.0f;
        } else if (e > m) {
            e = m;
            this.Ucap = this.Umax;
        } else {
            this.Ucap = (float)Math.sqrt(e);
            if (Float.isNaN(this.Ucap)) {
                this.Ucap = 0.0f;
            }
        }
        return e - d;
    }

    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.sideCfg = nbt.func_74771_c(name + "Cfg");
        this.Ucap = nbt.func_74760_g(name + "U");
        this.Iind[0] = nbt.func_74760_g(name + "Iy");
        this.Iind[1] = nbt.func_74760_g(name + "Iz");
        this.Iind[2] = nbt.func_74760_g(name + "Ix");
    }

    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74774_a(name + "Cfg", this.sideCfg);
        nbt.func_74780_a(name + "U", (double)this.Ucap);
        nbt.func_74780_a(name + "Iy", (double)this.Iind[0]);
        nbt.func_74780_a(name + "Iz", (double)this.Iind[1]);
        nbt.func_74780_a(name + "Ix", (double)this.Iind[2]);
    }

    public boolean isConnected(int s) {
        return (this.sideCfg >> s & 1) != 0;
    }

    public void update(IAbstractTile tile) {
        int i = 0;
        int s = 0;
        while (i < 3) {
            ICapabilityProvider te;
            if ((this.sideCfg >> s & 1) != 0 && (te = tile.getTileOnSide(EnumFacing.field_82609_l[s])) != null && te.hasCapability(Capabilities.ELECTRIC_CAPABILITY, EnumFacing.field_82609_l[s | 1])) {
                PipeEnergy energy = (PipeEnergy)te.getCapability(Capabilities.ELECTRIC_CAPABILITY, EnumFacing.field_82609_l[s | 1]);
                float ii = (this.Ucap - energy.Ucap) / this.Zcond;
                float ud = (ii + this.Iind[i]) * 0.5f;
                this.Ucap -= ud;
                energy.Ucap += ud;
                this.Iind[i] = ii;
            }
            i = (byte)(i + 1);
            s = (byte)(s + 2);
        }
        if (this.Ucap > (float)this.Umax) {
            this.Ucap = this.Umax;
        }
    }

    public static Object[] getEnergyInfo(float U1, float U0, float R) {
        float I = (U1 - U0) / R;
        float P = (U1 + U0) * I;
        return new Object[]{Float.valueOf(P / 1000.0f), Float.valueOf(I)};
    }
}

