/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.energy;

import cd4017be.api.energy.EnergyAutomation;
import cd4017be.api.energy.EnergyForge;
import cd4017be.api.energy.EnergyIndustrialCraft;
import cd4017be.api.energy.EnergyOpenComputers;
import cd4017be.api.energy.EnergyVoidcraft;
import cd4017be.api.recipes.RecipeScriptContext;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;

public class EnergyAPI {
    public static ArrayList<IEnergyHandler> handlers = new ArrayList();
    public static final IEnergyAccess NULL = new NullAccess();
    public static final float IA_value = 1000.0f;
    public static float RF_value;
    public static float EU_value;
    public static float OC_value;
    public static float VC_value;

    public static void init(RecipeScriptContext.ConfigConstants cfg) {
        if (Loader.isModLoaded((String)"Automation")) {
            handlers.add(new EnergyAutomation());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Inductive Automation Energy-API", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            OC_value = (float)cfg.getNumber("energy_value_OC", 1000.0);
            if (!Float.isNaN(OC_value)) {
                handlers.add(new EnergyOpenComputers());
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Open Computers Energy-API with %s J / OC-unit", (Object[])new Object[]{Float.valueOf(OC_value)});
            } else {
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"NOT added Open Computers Energy-API (disabled by config)", (Object[])new Object[0]);
            }
        }
        if (!Float.isNaN(RF_value = (float)cfg.getNumber("energy_value_RF", 100.0))) {
            handlers.add(new EnergyForge());
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added Forge Energy-API with %s J / Flux", (Object[])new Object[]{Float.valueOf(RF_value)});
        } else {
            FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"NOT added Forge Energy-API (disabled by config)", (Object[])new Object[0]);
        }
        if (Loader.isModLoaded((String)"ic2")) {
            EU_value = (float)cfg.getNumber("energy_value_EU", 400.0);
            if (!Float.isNaN(EU_value)) {
                handlers.add(new EnergyIndustrialCraft());
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added IC2 Energy-API with %s J / EU", (Object[])new Object[]{Float.valueOf(EU_value)});
            } else {
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"NOT added IC2 Energy-API (disabled by config)", (Object[])new Object[0]);
            }
        }
        if (Loader.isModLoaded((String)"voidcraft")) {
            try {
                VC_value = (float)cfg.getNumber("energy_value_VC", 1000.0);
                if (!Float.isNaN(VC_value)) {
                    handlers.add(new EnergyVoidcraft());
                    FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"added VoidCraft Energy-API with %s J / VC-unit", (Object[])new Object[]{Float.valueOf(VC_value)});
                } else {
                    FMLLog.log((String)"CD4017BE_lib", (Level)Level.INFO, (String)"NOT added VoidCraft Energy-API (disabled by config)", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                FMLLog.log((String)"CD4017BE_lib", (Level)Level.ERROR, (Throwable)e, (String)"failed to add VoidCraft Energy-API!", (Object[])new Object[0]);
            }
        }
    }

    public static IEnergyAccess get(TileEntity te, EnumFacing s) {
        if (te == null) {
            return NULL;
        }
        if (te instanceof IEnergyAccess) {
            return (IEnergyAccess)te;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(te, s);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    public static IEnergyAccess get(ItemStack item, int s) {
        if (item == null || item.func_77973_b() == null || item.func_190916_E() != 1) {
            return NULL;
        }
        for (IEnergyHandler c : handlers) {
            IEnergyAccess e = c.create(item, s);
            if (e == null) continue;
            return e;
        }
        return NULL;
    }

    static class NullAccess
    implements IEnergyAccess {
        NullAccess() {
        }

        @Override
        public float getStorage() {
            return 0.0f;
        }

        @Override
        public float getCapacity() {
            return 0.0f;
        }

        @Override
        public float addEnergy(float e) {
            return 0.0f;
        }
    }

    public static interface IEnergyHandler {
        public IEnergyAccess create(TileEntity var1, EnumFacing var2);

        public IEnergyAccess create(ItemStack var1, int var2);
    }

    public static interface IEnergyAccess {
        public float getStorage();

        public float getCapacity();

        public float addEnergy(float var1);
    }
}

