/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes;

import cd4017be.api.recipes.OreGenHandler;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.recipes.mods.ImmersiveEngineeringModule;
import cd4017be.api.recipes.vanilla.CraftingRecipeIterator;
import cd4017be.api.recipes.vanilla.FuelHandler;
import cd4017be.api.recipes.vanilla.SmeltingIterator;
import cd4017be.lib.Lib;
import cd4017be.lib.script.Function;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.templates.NBTRecipe;
import cd4017be.lib.util.OreDictStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeAPI {
    public static final HashMap<String, IRecipeHandler> Handlers = new HashMap();
    public static final HashMap<String, IRecipeList> Lists = new HashMap();

    public static void addModModules(RecipeScriptContext cont) {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            cont.add(new ImmersiveEngineeringModule());
        }
    }

    public static Predicate<Object> getFilter(Object o) {
        if (o instanceof String) {
            return new RegexFilter((String)o);
        }
        if (o instanceof ItemStack) {
            ItemStack item = (ItemStack)o;
            return p -> p instanceof ItemStack && item.func_77969_a((ItemStack)p);
        }
        if (o instanceof FluidStack) {
            FluidStack fluid = (FluidStack)o;
            return p -> p instanceof FluidStack && fluid.isFluidEqual((FluidStack)p);
        }
        if (o instanceof OreDictStack) {
            OreDictStack ore = (OreDictStack)o;
            return p -> p instanceof OreDictStack ? ore.ID == ((OreDictStack)p).ID : (p instanceof String ? ore.id.equals((String)p) : p instanceof ItemStack && ore.isEqual((ItemStack)p));
        }
        if (o == null) {
            return p -> p == null;
        }
        return p -> o.equals(p);
    }

    public static void createOreDictEntries(Class<?> c, String name) {
        block3: {
            block2: {
                if (!Block.class.isAssignableFrom(c)) break block2;
                for (Block block : Block.field_149771_c) {
                    Item item;
                    if (!c.isInstance(block) || (item = Item.func_150898_a((Block)block)) == null) continue;
                    OreDictionary.registerOre((String)name, (Item)item);
                }
                break block3;
            }
            if (!Item.class.isAssignableFrom(c)) break block3;
            for (Item item : Item.field_150901_e) {
                if (!c.isInstance(item)) continue;
                OreDictionary.registerOre((String)name, (Item)item);
            }
        }
    }

    static {
        Handlers.put("shaped", p -> {
            int i;
            String[] pattern = p.getString(2).split("/");
            int n = p.param.length - 3;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 3];
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(p.get(1, ItemStack.class), arr));
        });
        Handlers.put("shapedNBT", p -> {
            int i;
            String[] pattern = p.getString(3).split("/");
            int n = p.param.length - 4;
            Object[] arr = new Object[n * 2 + pattern.length];
            for (i = 0; i < pattern.length; ++i) {
                arr[i] = pattern[i];
            }
            for (i = 0; i < n; ++i) {
                arr[pattern.length + i * 2] = Character.valueOf(Character.forDigit(i, 9));
                arr[pattern.length + i * 2 + 1] = p.param[i + 4];
            }
            GameRegistry.addRecipe((IRecipe)new NBTRecipe(p.get(2, ItemStack.class), p.getString(1), arr));
        });
        Handlers.put("ore", p -> {
            String name = p.getString(1);
            for (int i = 2; i < p.param.length; ++i) {
                OreDictionary.registerOre((String)name, (ItemStack)p.get(i, ItemStack.class));
            }
        });
        Lists.put("ore", p -> new Function.FilteredIterator(new Function.ArrayIterator(OreDictionary.getOreNames()), new RegexFilter(p.getString(1))));
        Lists.put("craftIng", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), false));
        Lists.put("craftRes", p -> new CraftingRecipeIterator(RecipeAPI.getFilter(p.get(1)), true));
        Lists.put("smeltIng", p -> new SmeltingIterator(RecipeAPI.getFilter(p.get(1)), false));
        Lists.put("smeltRes", p -> new SmeltingIterator(RecipeAPI.getFilter(p.get(1)), true));
        Handlers.put("shapeless", p -> GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(p.get(1, ItemStack.class), Arrays.copyOfRange(p.param, 2, p.param.length))));
        Handlers.put("smelt", p -> GameRegistry.addSmelting((ItemStack)p.get(1, ItemStack.class), (ItemStack)p.get(2, ItemStack.class), (float)(p.param.length > 3 ? (float)p.getNumber(3) : 0.0f)));
        Handlers.put("fuel", new FuelHandler());
        Handlers.put("worldgen", new OreGenHandler());
        Handlers.put("item", p -> {
            int n = p.param.length;
            Lib.materials.addMaterial((int)p.getNumber(1), p.getString(2), n > 3 ? p.getString(3) : null, n > 4 ? p.getString(4) : null);
        });
    }

    public static class RegexFilter
    implements Predicate<Object> {
        private final Pattern pattern;

        public RegexFilter(String expr) {
            this.pattern = Pattern.compile(expr);
        }

        @Override
        public boolean test(Object o) {
            return o != null && this.pattern.matcher(o.toString()).matches();
        }
    }

    public static interface IRecipeList {
        public Function.Iterator list(Parameters var1);
    }

    public static interface IRecipeHandler {
        public void addRecipe(Parameters var1);
    }
}

