/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.mods;

import cd4017be.api.recipes.RecipeModule;
import cd4017be.lib.script.Parameters;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ImmersiveEngineeringModule
extends RecipeModule {
    public ImmersiveEngineeringModule() {
        super("IE");
        this.mkRcp("AlloyRecipe", "Alloy");
        this.mkRcp("ArcFurnaceRecipe", "Arc");
        this.mkRcp("BlastFurnaceRecipe", "Blast");
        this.mkRcp("BottlingMachineRecipe", "Bottle");
        this.mkRcp("CokeOvenRecipe", "Coke");
        this.mkRcp("CrusherRecipe", "Crush");
        this.mkRcp("FermenterRecipe", "Ferment");
        this.mkRcp("MetalPressRecipe", "Press");
        this.mkRcp("MixerRecipe", "Mix");
        this.mkRcp("RefineryRecipe", "Refine");
        this.mkRcp("SqueezerRecipe", "Squeeze");
        FMLLog.log((String)"CD4017BE_lib|RecipeAPI", (Level)Level.INFO, (String)"added ImmersiveEngineering wrapper module", (Object[])new Object[0]);
    }

    private void mkRcp(String name, String id) {
        try {
            Class<?> c = Class.forName("blusunrize.immersiveengineering.api.crafting." + name);
            for (Method m : c.getDeclaredMethods()) {
                if (!m.getName().equals("addRecipe")) continue;
                this.methods.put("add" + id, new AddRecipe(m));
            }
            Method rem = c.getMethod("removeRecipes", ItemStack.class);
            this.methods.put("rem" + id, p -> rem.invoke(null, p.get(0, ItemStack.class)));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            FMLLog.log((String)"CD4017BE_lib|RecipeAPI", (Level)Level.WARN, (String)"Problem occoured adding ImmersiveEngineering handler %s: %s", (Object[])new Object[]{name, e.toString()});
        }
    }

    private static class AddRecipe
    implements RecipeModule.Handler {
        final Method m;

        AddRecipe(Method m) {
            this.m = m;
        }

        @Override
        public Object handle(Parameters param) throws Exception {
            Class<?>[] types = this.m.getParameterTypes();
            Object[] p = new Object[types.length];
            for (int i = 0; i < p.length; ++i) {
                Class<?> t = types[i];
                p[i] = t == Integer.TYPE ? Integer.valueOf((int)param.getNumber(i)) : (t == Object[].class && i == p.length - 1 ? (param.param.length > i ? param.getArray(i) : null) : (t == ItemStack.class && i < param.param.length && param.param[i] == null ? ItemStack.field_190927_a : param.get(i, t)));
            }
            return this.m.invoke(null, p);
        }
    }
}

