/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.api.recipes.vanilla.ShapedIngredients;
import cd4017be.api.recipes.vanilla.ShapelessIngredients;
import cd4017be.lib.script.Function;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class CraftingRecipeIterator
implements Function.Iterator {
    private final List<IRecipe> list;
    private final Predicate<Object> key;
    private final boolean in;
    private int idx;
    private Object[] curElement;
    private IRecipe curRecipe;

    public CraftingRecipeIterator(Predicate<Object> key, boolean res) {
        this.key = key;
        this.list = CraftingManager.func_77594_a().func_77592_b();
        this.in = !res;
        this.idx = -1;
    }

    @Override
    public Object get() {
        return this.curElement;
    }

    @Override
    public void set(Object o) {
        if (this.list.get(this.idx) != this.curRecipe) {
            throw new ConcurrentModificationException();
        }
        if (o == null) {
            this.list.remove(this.idx--);
        } else if (o == this.curElement && this.curElement[0] != this.curRecipe.func_77571_b()) {
            if (!(this.curElement[0] instanceof ItemStack)) {
                throw new IllegalArgumentException("ItemStack expected");
            }
            ItemStack item = (ItemStack)this.curElement[0];
            if (this.curRecipe instanceof ShapedRecipes) {
                ShapedRecipes sr = (ShapedRecipes)this.curRecipe;
                this.curRecipe = new ShapedRecipes(sr.field_77576_b, sr.field_77577_c, sr.field_77574_d, item);
            } else if (this.curRecipe instanceof ShapelessRecipes) {
                ShapelessRecipes sr = (ShapelessRecipes)this.curRecipe;
                this.curRecipe = new ShapelessRecipes(item, sr.field_77579_b);
            } else if (this.curRecipe instanceof ShapedOreRecipe) {
                ShapedOreRecipe sr = (ShapedOreRecipe)this.curRecipe;
                ShapedOreRecipe nr = new ShapedOreRecipe(item, CraftingRecipeIterator.emptyGrid(sr.getWidth(), sr.getHeight()));
                System.arraycopy(sr.getInput(), 0, nr.getInput(), 0, sr.getInput().length);
                this.curRecipe = nr;
            } else if (this.curRecipe instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe sr = (ShapelessOreRecipe)this.curRecipe;
                ShapelessOreRecipe nr = new ShapelessOreRecipe(item, new Object[0]);
                nr.getInput().addAll((Collection)sr.getInput());
                this.curRecipe = nr;
            } else {
                FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.WARN, (String)"could not replicate unknown recipe type: %s!", (Object[])new Object[]{this.curRecipe.getClass()});
                return;
            }
            this.list.set(this.idx, this.curRecipe);
        }
    }

    @Override
    public boolean next() {
        int l = this.list.size();
        while (++this.idx < l) {
            Function.Iterator ingred;
            this.curRecipe = this.list.get(this.idx);
            ItemStack result = this.curRecipe.func_77571_b();
            if (!this.in && !this.key.test(result)) continue;
            if (this.curRecipe instanceof ShapedOreRecipe) {
                ingred = new ShapedIngredients((ShapedOreRecipe)this.curRecipe, this.in ? this.key : null);
            } else if (this.curRecipe instanceof ShapelessOreRecipe) {
                ingred = new ShapelessIngredients((ShapelessOreRecipe)this.curRecipe, this.in ? this.key : null);
            } else if (this.curRecipe instanceof ShapedRecipes) {
                ingred = new Function.ArrayIterator(((ShapedRecipes)this.curRecipe).field_77574_d);
                if (this.in) {
                    ingred = new Function.FilteredIterator(ingred, this.key);
                }
            } else {
                if (!(this.curRecipe instanceof ShapelessRecipes)) continue;
                ingred = new Function.ListIterator(((ShapelessRecipes)this.curRecipe).field_77579_b);
                if (this.in) {
                    ingred = new Function.FilteredIterator(ingred, this.key);
                }
            }
            if (this.in) {
                if (!ingred.next()) continue;
                ingred.reset();
            }
            this.curElement = new Object[]{result, ingred};
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.idx = -1;
    }

    private static Object[] emptyGrid(int w, int h) {
        String line = "";
        for (int i = 0; i < w; ++i) {
            line = line + " ";
        }
        Object[] rcp = new Object[h];
        for (int i = 0; i < h; ++i) {
            rcp[i] = line;
        }
        return rcp;
    }
}

