/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.lib.script.Function;
import cd4017be.lib.util.OreDictStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

class ShapedIngredients
extends Function.ArrayIterator {
    private final Predicate<Object> key;
    private Object curElement;

    public ShapedIngredients(ShapedOreRecipe rcp, Predicate<Object> key) {
        super(rcp.getInput());
        this.key = key;
    }

    @Override
    public Object get() {
        return this.curElement;
    }

    @Override
    public void set(Object o) {
        if (o == this.curElement) {
            return;
        }
        if (o == null || o instanceof ItemStack) {
            this.arr[this.idx] = o;
        } else if (o instanceof OreDictStack) {
            this.arr[this.idx] = OreDictionary.getOres((String)((OreDictStack)o).id);
        } else {
            throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
        }
    }

    @Override
    public boolean next() {
        while (++this.idx < this.arr.length) {
            this.curElement = this.arr[this.idx];
            if (this.curElement instanceof List) {
                List list = (List)this.curElement;
                if (list.isEmpty()) continue;
                if (this.key == null) {
                    this.curElement = list.get(0);
                    return true;
                }
                for (Object o : list) {
                    if (!this.key.test(o)) continue;
                    this.curElement = o;
                    return true;
                }
                continue;
            }
            if (this.key != null && !this.key.test(this.curElement)) continue;
            return true;
        }
        return false;
    }
}

