/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.recipes.vanilla;

import cd4017be.lib.script.Function;
import cd4017be.lib.util.OreDictStack;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

class ShapelessIngredients
extends Function.ListIterator<Object> {
    private final Predicate<Object> key;
    private Object curElement;

    public ShapelessIngredients(ShapelessOreRecipe rcp, Predicate<Object> key) {
        super(rcp.getInput());
        this.key = key;
    }

    @Override
    public Object get() {
        return this.curElement;
    }

    @Override
    public void set(Object o) {
        if (o == this.curElement) {
            return;
        }
        if (o instanceof ItemStack) {
            this.arr.set(this.idx, o);
        } else if (o instanceof OreDictStack) {
            this.arr.set(this.idx, OreDictionary.getOres((String)((OreDictStack)o).id));
        } else if (o == null) {
            this.arr.remove(this.idx--);
        } else {
            throw new IllegalArgumentException("exp. ItemStack or OreDictStack");
        }
    }

    @Override
    public boolean next() {
        while (++this.idx < this.arr.size()) {
            this.curElement = this.arr.get(this.idx);
            if (this.curElement instanceof List) {
                List list = (List)this.curElement;
                if (list.isEmpty()) continue;
                if (this.key == null) {
                    this.curElement = list.get(0);
                    return true;
                }
                for (Object o : list) {
                    if (!this.key.test(o)) continue;
                    this.curElement = o;
                    return true;
                }
                continue;
            }
            if (this.key != null && !this.key.test(this.curElement)) continue;
            return true;
        }
        return false;
    }
}

