/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Lib;
import cd4017be.lib.util.Utils;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class BlockGuiHandler
implements IGuiHandler {
    private static final String guiChannel = "CD4017BE_gui";
    private static HashMap<Block, GuiEntry> gui_registry = new HashMap();
    public static BlockGuiHandler instance = new BlockGuiHandler();
    public static FMLEventChannel eventChannel;

    static void register() {
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(guiChannel);
        eventChannel.register((Object)instance);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Lib.instance, (IGuiHandler)instance);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerGui(Block id, Class<? extends GuiContainer> gui) {
        GuiEntry entry = gui_registry.get(id);
        if (entry != null) {
            if (entry.gui != null) {
                FMLLog.warning((String)"CD4017BE-modlib: GuiContainer %1$s overrrides already registered GuiContainer %2$s for Block-ID %3$d !", (Object[])new Object[]{gui.getName(), entry.gui.getName(), id});
            }
            entry.gui = gui;
        } else {
            FMLLog.warning((String)"CD4017BE-modlib: Failed to register GuiContainer %1$s because Block-ID %2$s is not registered!", (Object[])new Object[]{gui.getName(), id});
        }
    }

    public static void registerContainer(Block id, Class<? extends Container> container) {
        GuiEntry entry = new GuiEntry();
        entry.container = container;
        gui_registry.put(id, entry);
    }

    public static void openGui(EntityPlayer player, World world, BlockPos pos, int guiType) {
        if (Lib.instance != null) {
            player.openGui((Object)Lib.instance, guiType, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else {
            FMLLog.severe((String)"CD4017BE-lib: BlockGuiHandler failed to open Gui! No Mod registered!", (Object[])new Object[0]);
        }
    }

    public static void openItemGui(EntityPlayer player, EnumHand hand) {
        BlockGuiHandler.openGui(player, player.field_70170_p, Utils.NOWHERE, hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c : 40);
    }

    public static void openBlockGui(EntityPlayer player, World world, BlockPos pos) {
        BlockGuiHandler.openGui(player, world, pos, -1);
    }

    public static void sendPacketToServer(PacketBuffer data) {
        eventChannel.sendToServer(new FMLProxyPacket(data, guiChannel));
    }

    public static void sendPacketToPlayer(EntityPlayerMP player, PacketBuffer data) {
        eventChannel.sendTo(new FMLProxyPacket(data, guiChannel), player);
    }

    public static void sendPacketToAllNear(TileEntity tile, double range, PacketBuffer data) {
        BlockPos pos = tile.func_174877_v();
        eventChannel.sendToAllAround(new FMLProxyPacket(data, guiChannel), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range));
    }

    public static PacketBuffer getPacketTargetData(BlockPos pos) {
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.func_179255_a(pos);
        return data;
    }

    public static PacketBuffer getPacketForItem(int slot) {
        return BlockGuiHandler.getPacketTargetData(new BlockPos(slot, -1, 0));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        PacketBuffer data = new PacketBuffer(packet.payload());
        BlockPos target = null;
        try {
            target = data.func_179259_c();
            Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (container instanceof DataContainer && ((DataContainer)container).data.pos().equals((Object)target)) {
                ((DataContainer)container).onDataUpdate(data);
            } else {
                TileEntity te = Utils.getTileAt((World)Minecraft.func_71410_x().field_71441_e, target);
                if (te instanceof ServerPacketReceiver) {
                    ((ServerPacketReceiver)te).onPacketFromServer(data);
                }
            }
        }
        catch (Exception e) {
            String s = " ";
            byte[] d = data.array();
            for (int i = 8; i < data.writerIndex(); ++i) {
                s = s + Integer.toHexString(d[i] & 0xFF) + " ";
            }
            FMLLog.log((String)"CD4017BE_packet", (Level)Level.ERROR, (Throwable)e, (String)"reading server -> client packet for %s: [%s]", (Object[])new Object[]{target, s});
        }
    }

    @SubscribeEvent
    public void onPlayerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent event) {
        FMLProxyPacket packet = event.getPacket();
        if (!packet.channel().equals(guiChannel)) {
            return;
        }
        if (!(event.getHandler() instanceof NetHandlerPlayServer)) {
            FMLLog.log((Level)Level.WARN, (String)"NetHandler not instanceof NetHandlerPlayServer!", (Object[])new Object[0]);
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        PacketBuffer data = new PacketBuffer(packet.payload());
        BlockPos target = null;
        try {
            target = data.func_179259_c();
            if (target.func_177956_o() < 0) {
                int slot = target.func_177958_n();
                ItemStack item = player.field_71071_by.func_70301_a(slot);
                if (item.func_77973_b() instanceof ClientItemPacketReceiver) {
                    ((ClientItemPacketReceiver)item.func_77973_b()).onPacketFromClient(data, (EntityPlayer)player, item, slot);
                }
            } else {
                TileEntity te = Utils.getTileAt(player.field_70170_p, target);
                if (te instanceof ClientPacketReceiver) {
                    ((ClientPacketReceiver)te).onPacketFromClient(data, (EntityPlayer)player);
                }
            }
        }
        catch (Exception e) {
            String s = " ";
            byte[] d = data.array();
            for (int i = 8; i < data.writerIndex(); ++i) {
                s = s + Integer.toHexString(d[i] & 0xFF) + " ";
            }
            FMLLog.log((String)"CD4017BE_packet", (Level)Level.ERROR, (Throwable)e, (String)"reading client -> server packet for %s: [%s]", (Object[])new Object[]{target, s});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Container c;
        BlockPos pos = new BlockPos(x, y, z);
        if (ID < 0) {
            GuiEntry entry = gui_registry.get(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry == null || entry.container == null || !(te instanceof DataContainer.IGuiData)) return null;
            try {
                c = entry.container.getConstructor(DataContainer.IGuiData.class, EntityPlayer.class).newInstance((DataContainer.IGuiData)te, player);
            }
            catch (NoSuchMethodException ex) {
                FMLLog.severe((String)"CD4017BE-lib: TileContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.container.getName(), DataContainer.IGuiData.class.getName(), EntityPlayer.class.getName()});
                return null;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            ItemStack item = player.field_71071_by.func_70301_a(ID);
            if (!(item.func_77973_b() instanceof IGuiItem)) return null;
            c = ((IGuiItem)item.func_77973_b()).getContainer(item, player, world, pos, ID);
        }
        if (!(c instanceof DataContainer)) return c;
        ((DataContainer)c).data.initContainer((DataContainer)c);
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiContainer g;
        BlockPos pos = new BlockPos(x, y, z);
        if (ID < 0) {
            GuiEntry entry = gui_registry.get(world.func_180495_p(pos).func_177230_c());
            TileEntity te = world.func_175625_s(pos);
            if (entry == null || entry.gui == null || !(te instanceof DataContainer.IGuiData)) return null;
            if (player.field_71070_bA != null && player.field_71070_bA instanceof DataContainer && ((DataContainer)player.field_71070_bA).data == te) {
                return Minecraft.func_71410_x().field_71462_r;
            }
            try {
                g = entry.gui.getConstructor(DataContainer.IGuiData.class, EntityPlayer.class).newInstance((DataContainer.IGuiData)te, player);
            }
            catch (NoSuchMethodException ex) {
                FMLLog.severe((String)"CD4017BE-lib: GuiContainer %1$s is missing the Constructor ( %2$s , %3$s )", (Object[])new Object[]{entry.gui.getName(), DataContainer.IGuiData.class.getName(), EntityPlayer.class.getName()});
                return null;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        } else {
            ItemStack item = player.field_71071_by.func_70301_a(ID);
            if (!(item.func_77973_b() instanceof IGuiItem)) return null;
            g = ((IGuiItem)item.func_77973_b()).getGui(item, player, world, pos, ID);
        }
        if (!(g.field_147002_h instanceof DataContainer)) return g;
        DataContainer c = (DataContainer)g.field_147002_h;
        c.data.initContainer(c);
        c.refInts = c.data.getSyncVariables();
        if (c.refInts == null || !(c.data instanceof TileEntity)) return g;
        for (int i = 0; i < c.refInts.length; ++i) {
            c.data.setSyncVariable(i, 0);
        }
        return g;
    }

    private static class GuiEntry {
        Class<? extends Container> container;
        @SideOnly(value=Side.CLIENT)
        Class<? extends GuiContainer> gui;

        private GuiEntry() {
        }
    }

    public static interface ClientItemPacketReceiver {
        public void onPacketFromClient(PacketBuffer var1, EntityPlayer var2, ItemStack var3, int var4) throws IOException;
    }

    public static interface ClientPacketReceiver {
        public void onPacketFromClient(PacketBuffer var1, EntityPlayer var2) throws IOException;
    }

    public static interface ServerPacketReceiver {
        @SideOnly(value=Side.CLIENT)
        public void onPacketFromServer(PacketBuffer var1) throws IOException;
    }
}

