/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.api.Capabilities;
import cd4017be.api.computers.ComputerAPI;
import cd4017be.api.energy.EnergyAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.BlockItemRegistry;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.item.ItemMaterial;
import cd4017be.lib.render.ItemMaterialMeshDefinition;
import cd4017be.lib.render.SpecialModelLoader;
import cd4017be.lib.script.Module;
import cd4017be.lib.templates.NBTRecipe;
import cd4017be.lib.templates.TabMaterials;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.TooltipUtil;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="cd4017be_lib", useMetadata=true, acceptedMinecraftVersions="[1.11.2]")
public class Lib {
    public static final String ID = "cd4017be_lib";
    public static final String ConfigName = "core";
    @Mod.Instance
    public static Lib instance;
    public static ItemMaterial materials;
    public static final TabMaterials creativeTab;

    public Lib() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        FileUtil.initConfigDir(event);
        BlockGuiHandler.register();
        Capabilities.register();
        RecipeSorter.register((String)"cd4017be_lib:shapedNBT", NBTRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeScriptContext.instance = new RecipeScriptContext();
        RecipeScriptContext.instance.setup();
        RecipeScriptContext.instance.run("core.PRE_INIT");
        RecipeScriptContext.ConfigConstants cfg = new RecipeScriptContext.ConfigConstants((Module)RecipeScriptContext.instance.modules.get(ConfigName));
        EnergyAPI.init(cfg);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ComputerAPI.register();
        RecipeScriptContext.instance.runAll("INIT");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeScriptContext.instance.runAll("POST_INIT");
        TooltipUtil.addScriptVariables();
        if (event.getSide().isClient()) {
            Lib.clientPostInit();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void clientPostInit() {
        SpecialModelLoader.setMod(ID);
        BlockItemRegistry.registerRender(materials);
        BlockItemRegistry.registerRender(materials, (ItemMeshDefinition)new ItemMaterialMeshDefinition(materials));
    }

    @Mod.EventHandler
    public void afterStart(FMLServerAboutToStartEvent event) {
        RecipeScriptContext.instance = null;
        System.gc();
    }

    @Mod.EventHandler
    public void onShutdown(FMLServerStoppingEvent event) {
        TickRegistry.instance.clear();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> ev) {
        materials = new ItemMaterial("m");
        ev.getRegistry().register((IForgeRegistryEntry)materials.func_77637_a(creativeTab));
        Lib.creativeTab.item = new ItemStack((Item)materials);
    }

    static {
        creativeTab = new TabMaterials(ID);
    }
}

