/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib;

import cd4017be.lib.block.AdvancedBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;

public class TickRegistry {
    public static boolean DEBUG = false;
    public static final TickRegistry instance = new TickRegistry();
    public ArrayList<IUpdatable> updates = new ArrayList();
    private ArrayList<IUpdatable> swapList = new ArrayList();
    private ITickReceiver[] tickList = new ITickReceiver[8];
    private int tickers = 0;
    private int added;

    public static void register() {
    }

    private TickRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        String msg = "";
        if (!this.updates.isEmpty()) {
            ArrayList<IUpdatable> list = this.updates;
            this.updates = this.swapList;
            this.swapList = list;
            if (DEBUG) {
                msg = msg + String.format("%d singleTicks ", list.size());
            }
            for (IUpdatable update : list) {
                update.process();
            }
            list.clear();
        }
        if (this.tickers > 0) {
            int i = 0;
            for (int j = 0; j < this.tickers; ++j) {
                ITickReceiver tick = this.tickList[j];
                if (!tick.tick()) continue;
                if (i < j) {
                    this.tickList[i] = tick;
                }
                ++i;
            }
            if (i < this.tickers) {
                Arrays.fill(this.tickList, i, this.tickers, null);
                if (DEBUG) {
                    msg = msg + String.format("%d ", i - this.tickers);
                }
                this.tickers = i;
            }
        }
        if (DEBUG) {
            if (this.added > 0) {
                msg = msg + String.format("+%d ", this.added);
            }
            if (!msg.isEmpty()) {
                msg = msg + String.format("%d contTicks", this.tickers);
                FMLLog.log((String)"cd4017be_lib", (Level)Level.INFO, (String)msg, (Object[])new Object[0]);
            }
        }
        this.added = 0;
    }

    public void clear() {
        if (DEBUG) {
            FMLLog.log((String)"cd4017be_lib", (Level)Level.INFO, (String)"-%d contTicks due to server shutdown", (Object[])new Object[]{this.tickers});
        }
        Arrays.fill(this.tickList, 0, this.tickers, null);
        this.tickers = 0;
        this.updates.clear();
    }

    public void add(ITickReceiver tick) {
        if (Thread.currentThread().getName().startsWith("Client")) {
            throw new IllegalStateException("Adding ITickReceivers not allowed on client side!");
        }
        if (this.tickers == this.tickList.length) {
            ITickReceiver[] arr = new ITickReceiver[this.tickers << 1];
            System.arraycopy(this.tickList, 0, arr, 0, this.tickers);
            this.tickList = arr;
        }
        this.tickList[this.tickers++] = tick;
        ++this.added;
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load ev) {
        Chunk chunk = ev.getChunk();
        World world = chunk.func_177412_p();
        ChunkPos cp = chunk.func_76632_l();
        boolean loadedN = world.func_175667_e(cp.func_180331_a(0, 0, -1));
        boolean loadedS = world.func_175667_e(cp.func_180331_a(0, 0, 16));
        boolean loadedW = world.func_175667_e(cp.func_180331_a(-1, 0, 0));
        boolean loadedE = world.func_175667_e(cp.func_180331_a(16, 0, 0));
        for (Map.Entry e : chunk.func_177434_r().entrySet()) {
            BlockPos pos = (BlockPos)e.getKey();
            int x = pos.func_177958_n() & 0xF;
            int z = pos.func_177952_p() & 0xF;
            if (z == 0 && loadedN) {
                this.notifyNeighborTile(world, pos, EnumFacing.NORTH, (TileEntity)e.getValue());
            } else if (z == 15 && loadedS) {
                this.notifyNeighborTile(world, pos, EnumFacing.SOUTH, (TileEntity)e.getValue());
            }
            if (x == 0 && loadedW) {
                this.notifyNeighborTile(world, pos, EnumFacing.WEST, (TileEntity)e.getValue());
                continue;
            }
            if (x != 15 || !loadedE) continue;
            this.notifyNeighborTile(world, pos, EnumFacing.EAST, (TileEntity)e.getValue());
        }
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload ev) {
        boolean loadedE;
        boolean loadedW;
        boolean loadedS;
        ChunkPos cp;
        Chunk chunk = ev.getChunk();
        World world = chunk.func_177412_p();
        boolean loadedN = world.func_175667_e((cp = chunk.func_76632_l()).func_180331_a(0, 0, -1));
        if (loadedN | (loadedS = world.func_175667_e(cp.func_180331_a(0, 0, 16))) | (loadedW = world.func_175667_e(cp.func_180331_a(-1, 0, 0))) | (loadedE = world.func_175667_e(cp.func_180331_a(16, 0, 0)))) {
            for (BlockPos pos : chunk.func_177434_r().keySet()) {
                int x = pos.func_177958_n() & 0xF;
                int z = pos.func_177952_p() & 0xF;
                if (z == 0 && loadedN) {
                    this.notifyNeighborTile(world, pos, EnumFacing.NORTH, null);
                } else if (z == 15 && loadedS) {
                    this.notifyNeighborTile(world, pos, EnumFacing.SOUTH, null);
                }
                if (x == 0 && loadedW) {
                    this.notifyNeighborTile(world, pos, EnumFacing.WEST, null);
                    continue;
                }
                if (x != 15 || !loadedE) continue;
                this.notifyNeighborTile(world, pos, EnumFacing.EAST, null);
            }
        }
    }

    private void notifyNeighborTile(World world, BlockPos pos, EnumFacing side, TileEntity newTe) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te instanceof AdvancedBlock.INeighborAwareTile) {
            ((AdvancedBlock.INeighborAwareTile)te).neighborTileChange(newTe, side.func_176734_d());
        }
    }

    public static interface ITickReceiver {
        public boolean tick();
    }

    public static interface IUpdatable {
        public void process();
    }
}

