/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.block.BlockPipe;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.property.PropertyBlockMimic;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCoveredPipe
extends BlockPipe {
    public static BlockCoveredPipe create(String id, Material m, SoundType sound, Class<? extends TileEntity> tile, final int states) {
        return new BlockCoveredPipe(id, m, sound, CON_PROPS.length + 1, tile){

            @Override
            protected PropertyInteger createBaseState() {
                return states > 1 ? PropertyInteger.func_177719_a((String)"type", (int)0, (int)(states - 1)) : null;
            }
        };
    }

    protected BlockCoveredPipe(String id, Material m, SoundType sound, int mods, Class<? extends TileEntity> tile) {
        super(id, m, sound, mods, tile);
        this.setMultilayer();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String moduleVariant(int i) {
        return i < CON_PROPS.length ? CON_PROPS[i] : PropertyBlockMimic.instance.getName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class<?> moduleType(int i) {
        return i < CON_PROPS.length ? Byte.class : IBlockState.class;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] iPropertyArray;
        this.baseState = this.createBaseState();
        if (this.baseState == null) {
            iPropertyArray = new IProperty[]{};
        } else {
            IProperty[] iPropertyArray2 = new IProperty[1];
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[0] = this.baseState;
        }
        return new ExtendedBlockState((Block)this, iPropertyArray, new IUnlistedProperty[]{moduleRef, PropertyBlockMimic.instance});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState eState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)eState.getValue(moduleRef);
        if (tile == null) {
            return eState;
        }
        IBlockState cover = (IBlockState)tile.getModuleState(CON_PROPS.length);
        if (cover == null) {
            return eState;
        }
        return eState.withProperty((IUnlistedProperty)PropertyBlockMimic.instance, (Object)cover.func_177230_c().getExtendedState(cover.func_185899_b(world, pos), world, pos));
    }

    @Override
    public BlockPipe setSize(double size) {
        double min = 0.5 - (size /= 2.0);
        double max = 0.5 + size;
        this.boundingBox = new AxisAlignedBB[]{new AxisAlignedBB(min, min, min, max, max, max), new AxisAlignedBB(min, 0.0, min, max, min, max), new AxisAlignedBB(min, max, min, max, 1.0, max), new AxisAlignedBB(min, min, 0.0, max, max, min), new AxisAlignedBB(min, min, max, max, max, 1.0), new AxisAlignedBB(0.0, min, min, min, max, max), new AxisAlignedBB(max, min, min, 1.0, max, max), field_185505_j};
        return this;
    }

    protected IBlockState getCover(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof MultipartBlock.IModularTile) {
            return (IBlockState)((MultipartBlock.IModularTile)te).getModuleState(6);
        }
        return null;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover == null) {
            return this.field_149782_v;
        }
        float h = cover.func_185887_b(world, pos);
        return h < 0.0f ? h : h + this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        float r = this.field_149781_w / 5.0f;
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        if (cover != null) {
            r += cover.func_177230_c().getExplosionResistance(world, pos, exploder, explosion);
        }
        return r;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        IBlockState cover = this.getCover(world, pos);
        return cover == null || cover.func_177230_c().canEntityDestroy(cover, world, pos, entity);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover == null) {
            return this.field_149784_t;
        }
        return Math.max(this.field_149784_t, cover.func_185906_d());
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        if (cover == null) {
            return this.field_149786_r;
        }
        return Math.max(this.field_149786_r, cover.getLightOpacity(world, pos));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (super.doesSideBlockRendering(state, world, pos, face)) {
            return true;
        }
        IBlockState cover = this.getCover(world, pos);
        return cover != null && cover.doesSideBlockRendering(world, pos, face);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState cover = this.getCover(world, pos);
        return cover != null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        return cover == null ? this.field_149762_H : cover.func_177230_c().getSoundType(cover, world, pos, entity);
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        return cover != null && cover.func_177230_c().canSustainLeaves(cover, world, pos);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState cover = this.getCover(world, pos);
        return cover != null && cover.func_177230_c().canSustainPlant(cover, world, pos, direction, plantable);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        IBlockState cover = this.getCover(world, pos);
        return cover != null && cover.func_177230_c().isBurning(world, pos);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState cover = this.getCover((IBlockAccess)world, pos);
        return cover != null && cover.func_177230_c().isFireSource(world, pos, side);
    }
}

