/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.property.PropertyOrientation;
import cd4017be.lib.util.Orientation;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class OrientedBlock
extends AdvancedBlock {
    public PropertyOrientation orientProp;

    protected OrientedBlock(String id, Material m, SoundType sound, int flags, Class<? extends TileEntity> tile, PropertyOrientation prop) {
        super(id, m, sound, flags, tile);
    }

    public static OrientedBlock create(String id, Material m, SoundType sound, int flags, Class<? extends TileEntity> tile, final PropertyOrientation prop) {
        return new OrientedBlock(id, m, sound, flags, tile, prop){

            protected BlockStateContainer func_180661_e() {
                this.orientProp = prop;
                return new BlockStateContainer((Block)this, new IProperty[]{prop});
            }
        };
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orientProp, (Comparable)((Object)Orientation.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Orientation)((Object)state.func_177229_b((IProperty)this.orientProp))).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing s, float X, float Y, float Z, int m, EntityLivingBase placer, EnumHand hand) {
        int p = placer.field_70125_A > 45.0f ? 1 : (placer.field_70125_A < -35.0f ? -1 : 0);
        int y = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.orientProp, (Comparable)((Object)this.orientProp.getPlacementState(placer.func_70093_af() && (this.flags & 0x40000) == 0, y, p, s, X, Y, Z)));
    }

    @Override
    public OrientedBlock setBlockBounds(AxisAlignedBB box) {
        this.boundingBox = new AxisAlignedBB[16];
        for (Orientation o : this.orientProp.func_177700_c()) {
            this.boundingBox[o.ordinal()] = o.rotate(box);
        }
        return this;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        Orientation o = (Orientation)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.orientProp));
        Orientation no = this.orientProp.getRotatedState(o, axis);
        if (no == o) {
            return false;
        }
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)this.orientProp, (Comparable)((Object)no)));
        return true;
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return this.orientProp.rotations();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        int i = ((Orientation)((Object)state.func_177229_b((IProperty)this.orientProp))).ordinal();
        Orientation o = Orientation.values()[i & 0xC | rot.func_185833_a(i & 3, 4)];
        return this.orientProp.func_177700_c().contains((Object)o) ? state.func_177226_a((IProperty)this.orientProp, (Comparable)((Object)o)) : state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        int i = ((Orientation)((Object)state.func_177229_b((IProperty)this.orientProp))).ordinal();
        Orientation o = Orientation.values()[i & 0xC | mirror.func_185802_a(i & 3, 4)];
        return this.orientProp.func_177700_c().contains((Object)o) ? state.func_177226_a((IProperty)this.orientProp, (Comparable)((Object)o)) : state;
    }
}

