/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.render.IHardCodedModel;
import cd4017be.lib.render.model.BlockMimicModel;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public class MultipartModel
implements IModel,
IHardCodedModel {
    public final IModelProvider[] modelProvider;
    public final ResourceLocation[] baseModels;
    public final MultipartBlock block;
    public ItemOverrideList itemHandler = ItemOverrideList.field_188022_a;

    public MultipartModel(MultipartBlock block) {
        this.block = block;
        if (block.baseState == null) {
            this.baseModels = new ResourceLocation[]{new ModelResourceLocation(block.getRegistryName(), "base")};
        } else {
            Collection states = block.baseState.func_177700_c();
            this.baseModels = new ResourceLocation[states.size()];
            Iterator iterator = states.iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                this.baseModels[s] = new ModelResourceLocation(block.getRegistryName(), "base" + s);
            }
        }
        this.modelProvider = new IModelProvider[block.numModules];
        for (int i = 0; i < block.numModules; ++i) {
            Class<?> type = block.moduleType(i);
            if (type == Boolean.class) {
                this.modelProvider[i] = new ProviderBool((ResourceLocation)new ModelResourceLocation(block.getRegistryName(), block.moduleVariant(i)));
                continue;
            }
            if (type != IBlockState.class) continue;
            this.modelProvider[i] = BlockMimicModel.provider;
        }
    }

    public MultipartModel setPipeVariants(int n) {
        for (int i = 0; i < this.block.numModules; ++i) {
            Class<?> type = this.block.moduleType(i);
            if (type != Byte.class || this.modelProvider[i] != null) continue;
            ResourceLocation[] locs = new ResourceLocation[n];
            for (int j = 0; j < n; ++j) {
                locs[j] = new ModelResourceLocation(this.block.getRegistryName(), this.block.moduleVariant(i) + j);
            }
            this.modelProvider[i] = new ProviderByte(locs);
        }
        return this;
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (ResourceLocation resourceLocation : this.baseModels) {
            list.add(resourceLocation);
        }
        for (IModelProvider iModelProvider : this.modelProvider) {
            Collection<ResourceLocation> c = iModelProvider.getDependencies();
            if (c == null) continue;
            list.addAll(c);
        }
        return list;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        IBakedModel[] models = new IBakedModel[this.baseModels.length];
        for (int i = 0; i < this.baseModels.length; ++i) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.baseModels[i], (String)("missing base Model " + i));
            models[i] = model.bake(state, format, textureGetter);
        }
        for (IModelProvider provider : this.modelProvider) {
            provider.bake(state, format, textureGetter);
        }
        return new BakedMultipart(models);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    @Override
    public void onReload() {
    }

    public class ProviderByte
    implements IModelProvider {
        private final ResourceLocation[] models;
        private final IBakedModel[] baked;

        public ProviderByte(ResourceLocation ... models) {
            this.models = models;
            this.baked = new IBakedModel[models.length];
        }

        @Override
        public IBakedModel getModelFor(Object val) {
            if (!(val instanceof Byte)) {
                return null;
            }
            byte var = (Byte)val;
            return var >= 0 && var < this.models.length ? this.baked[var] : null;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Arrays.asList(this.models);
        }

        @Override
        public void bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            for (int i = 0; i < this.models.length; ++i) {
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.models[i], (String)"missing");
                this.baked[i] = model.bake(model.getDefaultState(), format, textureGetter);
            }
        }
    }

    public class ProviderBool
    implements IModelProvider {
        private final ResourceLocation model;
        private IBakedModel baked;

        public ProviderBool(ResourceLocation model) {
            this.model = model;
        }

        @Override
        public IBakedModel getModelFor(Object val) {
            return val == Boolean.TRUE ? this.baked : null;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Arrays.asList(this.model);
        }

        @Override
        public void bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.model, (String)"missing");
            this.baked = model.bake(model.getDefaultState(), format, textureGetter);
        }
    }

    public static interface IModelProvider {
        public IBakedModel getModelFor(Object var1);

        default public IBakedModel getModelFor(Object val, @Nonnull BlockRenderLayer layer) {
            return layer == BlockRenderLayer.CUTOUT ? this.getModelFor(val) : null;
        }

        public Collection<ResourceLocation> getDependencies();

        public void bake(IModelState var1, VertexFormat var2, Function<ResourceLocation, TextureAtlasSprite> var3);
    }

    public class BakedMultipart
    implements IBakedModel {
        public final IBakedModel[] base;

        private BakedMultipart(IBakedModel[] base) {
            this.base = base;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            IExtendedBlockState exState;
            MultipartBlock.IModularTile tile;
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            BlockRenderLayer layer = MultipartModel.this.block.renderMultilayer ? MinecraftForgeClient.getRenderLayer() : null;
            boolean render = true;
            if (state instanceof IExtendedBlockState && (render = (tile = (MultipartBlock.IModularTile)(exState = (IExtendedBlockState)state).getValue(MultipartBlock.moduleRef)) != null && (side != null || !tile.isOpaque()))) {
                for (int i = 0; i < MultipartModel.this.block.numModules; ++i) {
                    IBakedModel model;
                    Object val = tile.getModuleState(i);
                    IBakedModel iBakedModel = model = layer == null ? MultipartModel.this.modelProvider[i].getModelFor(val) : MultipartModel.this.modelProvider[i].getModelFor(val, layer);
                    if (model == null) continue;
                    list.addAll(model.func_188616_a(state, side, rand));
                }
            }
            if (render && (layer == null || layer == BlockRenderLayer.CUTOUT)) {
                list.addAll(this.base[MultipartModel.this.block.baseState == null ? 0 : (Integer)state.func_177229_b((IProperty)MultipartModel.this.block.baseState)].func_188616_a(state, side, rand));
            }
            return list;
        }

        public boolean func_177555_b() {
            return this.base[0].func_177555_b();
        }

        public boolean func_177556_c() {
            return this.base[0].func_177556_c();
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base[0].func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return MultipartModel.this.itemHandler;
        }

        public MultipartBlock getOwner() {
            return MultipartModel.this.block;
        }
    }
}

