/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.BakedModel;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.render.model.ParamertisedVariant;
import cd4017be.lib.render.model.RawModelData;
import cd4017be.lib.script.Parameters;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class NBTModel
implements IModel {
    private static final String NBT_AMBIENT_OCCLUSION = "ambOcc";
    private static final String NBT_GUI_3D = "gui3d";
    private static final String NBT_TRANSFORM = "item_transf";
    private static final String NBT_VERTEX_TRANSFORM = "vert_transf";
    private static final String NBT_UV_TRANSFORM = "uv_transf";
    private static final String NBT_TEX_TRANSFORM = "tex_remap";
    private static final String NBT_PARTICLE = "particle_tex";
    private static final String NBT_COLOR = "hasColor";
    private static final String NBT_CULLFACE = "cullfaces";
    private static final String NBT_TEXTURE = "textures";
    private static final String NBT_VERTEX = "vertices";
    private static final String NBT_UV = "uvs";
    private static final String NBT_QUAD = "quads";
    private static final String NBT_MASK = "mask";
    private final NBTTagCompound data;
    private final boolean coreVertices;
    private final boolean coreUVs;
    private final boolean diffuseLight;
    private final boolean gui3D;
    private final ResourceLocation[] textures;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform;

    public NBTModel(NBTTagCompound data) {
        this.data = data;
        this.coreVertices = data.func_150297_b(NBT_VERTEX, 11);
        this.coreUVs = data.func_150297_b(NBT_UV, 11);
        this.diffuseLight = !data.func_150297_b(NBT_AMBIENT_OCCLUSION, 1) || data.func_74767_n(NBT_AMBIENT_OCCLUSION);
        boolean bl = this.gui3D = !data.func_150297_b(NBT_GUI_3D, 1) || data.func_74767_n(NBT_GUI_3D);
        if (data.func_150297_b(NBT_TRANSFORM, 10)) {
            NBTTagCompound comp = data.func_74775_l(NBT_TRANSFORM);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(RawModelData.DEFAULT_TRANSFORM);
            boolean edit = false;
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                String key = RawModelData.TRANSFORMS[type.ordinal()];
                if (!comp.func_150297_b(key, 9)) continue;
                NBTTagList list = comp.func_150295_c(key, 5);
                Vector3f ofs = new Vector3f(list.func_150308_e(0), list.func_150308_e(1), list.func_150308_e(2));
                Vector3f scale = new Vector3f(list.func_150308_e(3), list.func_150308_e(4), list.func_150308_e(5));
                Vector3f rot = new Vector3f(list.func_150308_e(6), list.func_150308_e(7), list.func_150308_e(8));
                builder.put((Object)type, (Object)new TRSRTransformation(ofs, null, scale, TRSRTransformation.quatFromXYZDegrees((Vector3f)rot)));
                edit = true;
            }
            this.transform = edit ? builder.build() : RawModelData.DEFAULT_TRANSFORM;
            data.func_82580_o(NBT_TRANSFORM);
        } else {
            this.transform = RawModelData.DEFAULT_TRANSFORM;
        }
        NBTTagList list = data.func_150295_c(NBT_TEXTURE, 8);
        int n = list.func_74745_c();
        if (n < 1) {
            n = 1;
        }
        this.textures = new ResourceLocation[n];
        for (int i = 0; i < n; ++i) {
            this.textures[i] = new ResourceLocation(list.func_150307_f(i));
        }
        data.func_82580_o(NBT_TEXTURE);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(this.textures);
    }

    public IntArrayModel bakeTESR(ParamertisedVariant variant) {
        int[][] vdata = this.getModelData(variant);
        int[] vertices = vdata[0];
        int[] uvs = vdata[1];
        int[] faces = vdata[2];
        int[] texidx = vdata[3];
        int cmode = vdata[4][0];
        int c = vdata[4][1];
        TextureAtlasSprite[] cache = new TextureAtlasSprite[this.textures.length];
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        Function texGetter = rl -> map.func_110572_b(rl.toString());
        int o = cmode == 0 ? 7 : (cmode == 1 ? 4 : 3);
        int n = faces.length / o;
        int[] vertexData = new int[n * 28];
        int l = 0;
        for (int i = 0; i < n; ++i) {
            int j = i * o;
            int vi = faces[j++];
            int uvi = faces[j++];
            int nti = faces[j++];
            if (cmode == 1) {
                c = faces[j];
            }
            TextureAtlasSprite tex = this.getTexture(cache, nti >> 24 & 0xFF, texidx, (Function<ResourceLocation, TextureAtlasSprite>)texGetter);
            int m = 0;
            while (m < 4) {
                int k = (vi & 0xFF) * 3;
                vertexData[l++] = vertices[k++];
                vertexData[l++] = vertices[k++];
                vertexData[l++] = vertices[k];
                vertexData[l++] = cmode == 0 ? faces[j++] : c;
                k = (uvi & 0xFF) * 2;
                vertexData[l++] = Float.floatToRawIntBits(tex.func_94214_a((double)Float.intBitsToFloat(uvs[k++])));
                vertexData[l++] = Float.floatToRawIntBits(tex.func_94207_b((double)Float.intBitsToFloat(uvs[k])));
                vertexData[l++] = 0;
                ++m;
                vi >>= 8;
                uvi >>= 8;
            }
        }
        return new IntArrayModel(vertexData);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int i;
        boolean hasNormal;
        boolean bl = hasNormal = format == DefaultVertexFormats.field_176599_b;
        if (format != DefaultVertexFormats.field_176600_a && !hasNormal) {
            return null;
        }
        ParamertisedVariant pstate = state instanceof ParamertisedVariant ? (ParamertisedVariant)state : (state instanceof ModelRotation ? new ParamertisedVariant((ModelRotation)state) : ParamertisedVariant.BASE);
        NBTTagCompound tag = this.data.func_74775_l(pstate.subModel);
        int[][] vdata = this.getModelData(pstate);
        int[] vertices = vdata[0];
        int[] uvs = vdata[1];
        int[] faces = vdata[2];
        int[] texidx = vdata[3];
        int cmode = vdata[4][0];
        int c = vdata[4][1];
        TextureAtlasSprite[] cache = new TextureAtlasSprite[this.textures.length];
        BakedModel model = new BakedModel(this.getTexture(cache, tag.func_74771_c(NBT_PARTICLE), texidx, bakedTextureGetter), this.transform, this.diffuseLight, this.gui3D);
        byte[] cf = tag.func_74770_j(NBT_CULLFACE);
        List<BakedQuad>[] quads = model.quads;
        for (int i2 = 0; i2 < quads.length; ++i2) {
            quads[i2] = new ArrayList<BakedQuad>();
        }
        int o = cmode == 0 ? 7 : (cmode == 1 ? 4 : 3);
        int n = faces.length / o;
        for (i = 0; i < n; ++i) {
            int j = i * o;
            int vi = faces[j++];
            int uvi = faces[j++];
            int nti = faces[j++];
            if (cmode == 1) {
                c = faces[j];
            }
            TextureAtlasSprite tex = this.getTexture(cache, nti >> 24 & 0xFF, texidx, bakedTextureGetter);
            nti = hasNormal ? Util.rotateNormal(nti & 0xFFFFFF, pstate.orient) : 0;
            int[] vertexData = new int[28];
            int l = 0;
            while (l < 28) {
                int k = (vi & 0xFF) * 3;
                vertexData[l++] = vertices[k++];
                vertexData[l++] = vertices[k++];
                vertexData[l++] = vertices[k];
                vertexData[l++] = cmode == 0 ? faces[j++] : c;
                k = (uvi & 0xFF) * 2;
                vertexData[l++] = Float.floatToRawIntBits(tex.func_94214_a((double)(Float.intBitsToFloat(uvs[k++]) * 16.0f)));
                vertexData[l++] = Float.floatToRawIntBits(tex.func_94207_b((double)(Float.intBitsToFloat(uvs[k]) * 16.0f)));
                vertexData[l++] = nti;
                vi >>= 8;
                uvi >>= 8;
            }
            quads[i < cf.length && (j = cf[i] & 0xFF) < 6 ? j + 1 : 0].add(new BakedQuad(vertexData, -1, FaceBakery.func_178410_a((int[])vertexData), tex, this.diffuseLight, format));
        }
        for (i = 0; i < quads.length; ++i) {
            if (!quads[i].isEmpty()) continue;
            quads[i] = Collections.emptyList();
        }
        return model;
    }

    private int[][] getModelData(ParamertisedVariant variant) {
        NBTTagCompound tag = this.data.func_74775_l(variant.subModel);
        int[] vertices = (this.coreVertices ? this.data : tag).func_74759_k(NBT_VERTEX);
        int[] uvs = (this.coreUVs ? this.data : tag).func_74759_k(NBT_UV);
        int[] remap = null;
        int colorMode = tag.func_74771_c(NBT_COLOR);
        int color = -1;
        if (variant.params != null) {
            ModelRotation orient;
            boolean flag;
            NBTTagList vt = tag.func_150295_c(NBT_TEX_TRANSFORM, 10);
            if (vt.func_82582_d()) {
                vt = this.data.func_150295_c(NBT_TEX_TRANSFORM, 10);
            }
            if (!vt.func_82582_d()) {
                remap = new int[this.textures.length];
                for (int i = 0; i < remap.length; ++i) {
                    remap[i] = i;
                }
                for (NBTBase e : vt) {
                    int ofs;
                    NBTTagCompound nbt = (NBTTagCompound)e;
                    try {
                        ofs = nbt.func_74771_c("shift") * (int)variant.params.getNumber(nbt.func_74771_c("par"));
                    }
                    catch (IllegalArgumentException ex) {
                        continue;
                    }
                    for (byte src : nbt.func_74770_j("ids")) {
                        int j;
                        int i = src & 0xFF;
                        if (i >= remap.length || (j = ofs + (src & 0xFF)) < 0 || j >= remap.length) continue;
                        remap[i] = j;
                    }
                }
            }
            vt = tag.func_150295_c(NBT_UV_TRANSFORM, 10);
            if (this.coreUVs && vt.func_82582_d()) {
                vt = this.data.func_150295_c(NBT_UV_TRANSFORM, 10);
            }
            if (!vt.func_82582_d()) {
                uvs = this.transform(uvs, 2, vt, variant.params);
            }
            vt = tag.func_150295_c(NBT_VERTEX_TRANSFORM, 10);
            if (this.coreVertices && vt.func_82582_d()) {
                vt = this.data.func_150295_c(NBT_VERTEX_TRANSFORM, 10);
            }
            if (!(flag = vt.func_82582_d())) {
                vertices = this.transform(vertices, 3, vt, variant.params);
            }
            if ((orient = variant.orient) != ModelRotation.X0_Y0) {
                if (flag) {
                    vertices = (int[])vertices.clone();
                }
                for (int i = 0; i < vertices.length; i += 3) {
                    Util.rotate(vertices, i, orient);
                }
            }
            if (colorMode >= 0) {
                try {
                    String s = variant.params.getString(colorMode);
                    if (s.startsWith("0x")) {
                        color = Integer.parseUnsignedInt(s.substring(2), 16) | 0xFF000000;
                        color = color & 0xFF00FF00 | color << 16 & 0xFF0000 | color >> 16 & 0xFF;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (colorMode >= 0) {
            colorMode = -1;
        }
        return new int[][]{vertices, uvs, tag.func_74759_k(NBT_QUAD), remap, {colorMode + 3, color}};
    }

    private TextureAtlasSprite getTexture(TextureAtlasSprite[] cache, int i, int[] remap, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite tex;
        if (i > cache.length || i < 0) {
            i = 0;
        }
        if ((tex = cache[i]) == null) {
            cache[i] = tex = (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.textures[remap == null ? i : remap[i]]);
        }
        return tex;
    }

    private int[] transform(int[] data, int dim, NBTTagList transf, Parameters param) {
        data = (int[])data.clone();
        for (NBTBase tag : transf) {
            int k;
            NBTTagCompound nbt = (NBTTagCompound)tag;
            float[] ofs = new float[dim];
            float[] scale = new float[dim];
            if (!nbt.func_150297_b("s_", 9)) {
                for (int i = 0; i < dim; ++i) {
                    scale[i] = 1.0f;
                }
            }
            for (String k2 : nbt.func_150296_c()) {
                float arg;
                float[] arr;
                if (k2.startsWith("s")) {
                    arr = scale;
                } else {
                    if (!k2.startsWith("o")) continue;
                    arr = ofs;
                }
                String p = k2.substring(1);
                if (p.equals("_")) {
                    arg = 1.0f;
                } else {
                    try {
                        arg = (float)param.getNumber(Integer.parseInt(p));
                    }
                    catch (IllegalArgumentException e) {
                        arg = 0.0f;
                    }
                }
                if (arg == 0.0f) continue;
                NBTTagList vec = nbt.func_150295_c(k2, 5);
                for (int i = 0; i < dim; ++i) {
                    int n = i;
                    arr[n] = arr[n] + vec.func_150308_e(i) * arg;
                }
            }
            BitSet mask = BitSet.valueOf(nbt.func_74770_j(NBT_MASK));
            int i = mask.nextSetBit(0);
            while (i >= 0 && (k = i * dim) + dim <= data.length) {
                int j = 0;
                while (j < dim) {
                    data[k] = Float.floatToIntBits(ofs[j] + scale[j] * Float.intBitsToFloat(data[k]));
                    ++j;
                    ++k;
                }
                i = mask.nextSetBit(i + 1);
            }
        }
        return data;
    }

    public IModelState getDefaultState() {
        return ParamertisedVariant.BASE;
    }
}

