/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.render.Util;
import cd4017be.lib.render.model.ModelContext;
import cd4017be.lib.script.Module;
import cd4017be.lib.util.Utils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class RawModelData
implements IModel {
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> DEFAULT_TRANSFORM;
    protected static final String[] TRANSFORMS;
    private final int[][] quads = new int[7][];
    private final boolean diffuseLight;
    private final boolean gui3D;
    private final ResourceLocation[] textures;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform;

    public RawModelData(Module script, ModelContext context) {
        this.diffuseLight = this.read(script.read("ambientOcclusion"), true);
        this.gui3D = this.read(script.read("isGui3D"), true);
        this.textures = this.readTextures(script.read("textures"));
        this.transform = this.readTransf(script);
        for (int i = 0; i < this.quads.length; ++i) {
            List<ModelContext.Quad> list = context.quads[i];
            if (list == null) continue;
            int[] data = new int[28 * list.size()];
            int j = 0;
            for (ModelContext.Quad quad : list) {
                if (quad.tex < 0 || quad.tex >= this.textures.length) {
                    throw new IllegalStateException("invalid texture index " + quad.tex + " !");
                }
                for (int k = 0; k < 4; ++k) {
                    double[] vert = quad.vertices[k];
                    data[j++] = Float.floatToRawIntBits((float)vert[0] / 16.0f);
                    data[j++] = Float.floatToRawIntBits((float)vert[1] / 16.0f);
                    data[j++] = Float.floatToRawIntBits((float)vert[2] / 16.0f);
                    data[j++] = (int)MathHelper.func_151237_a((double)(vert[5] * 255.0), (double)0.0, (double)255.0) | (int)MathHelper.func_151237_a((double)(vert[6] * 255.0), (double)0.0, (double)255.0) << 8 | (int)MathHelper.func_151237_a((double)(vert[7] * 255.0), (double)0.0, (double)255.0) << 16 | (int)MathHelper.func_151237_a((double)(vert[8] * 255.0), (double)0.0, (double)255.0) << 24;
                    data[j++] = Float.floatToRawIntBits((float)vert[3]);
                    data[j++] = Float.floatToRawIntBits((float)vert[4]);
                    data[j++] = this.getNormal(quad.vertices, k) | quad.tex << 24;
                }
            }
            this.quads[i] = data;
        }
    }

    private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> readTransf(Module script) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(DEFAULT_TRANSFORM);
        boolean edit = false;
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation t = RawModelData.getTransform(script.read("dsp_" + TRANSFORMS[type.ordinal()]));
            if (t == null) continue;
            builder.put((Object)type, (Object)t);
            edit = true;
        }
        return edit ? builder.build() : DEFAULT_TRANSFORM;
    }

    private static TRSRTransformation getTransform(Object par) {
        if (!(par instanceof Object[])) {
            return null;
        }
        Object[] arr = (Object[])par;
        if (arr.length < 3) {
            return null;
        }
        Vector3f scale = RawModelData.read(arr[1]);
        Vector3f ofs = RawModelData.read(arr[0]);
        ofs.scale(0.0625f);
        return new TRSRTransformation(ofs, null, scale, TRSRTransformation.quatFromXYZDegrees((Vector3f)RawModelData.read(arr[2])));
    }

    private static Vector3f read(Object o) {
        if (o instanceof double[]) {
            double[] vec = (double[])o;
            return vec.length < 3 ? null : new Vector3f((float)vec[0], (float)vec[1], (float)vec[2]);
        }
        return null;
    }

    private boolean read(Object val, boolean def) {
        return val instanceof Boolean ? (Boolean)val : def;
    }

    private ResourceLocation[] readTextures(Object par) {
        if (!(par instanceof Object[])) {
            throw new IllegalStateException("'textures' variable not defined! At least one texture required for particles.");
        }
        Object[] arr = (Object[])par;
        if (arr.length == 0) {
            throw new IllegalStateException("'textures' variable is empty array! At least one texture required for particles.");
        }
        ResourceLocation[] textures = new ResourceLocation[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            textures[i] = new ResourceLocation((String)arr[i]);
        }
        return textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Arrays.asList(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite[] textureAtlasSpriteArray;
        boolean hasNormal;
        boolean bl = hasNormal = format == DefaultVertexFormats.field_176599_b;
        if (format != DefaultVertexFormats.field_176600_a && !hasNormal) {
            return null;
        }
        ModelRotation orient = state instanceof ModelRotation ? (ModelRotation)state : ModelRotation.X0_Y0;
        int n = this.textures.length;
        if (n > 0) {
            textureAtlasSpriteArray = Utils.init(new TextureAtlasSprite[n], i -> (TextureAtlasSprite)bakedTextureGetter.apply((Object)this.textures[i]));
        } else {
            TextureAtlasSprite[] textureAtlasSpriteArray2 = new TextureAtlasSprite[1];
            textureAtlasSpriteArray = textureAtlasSpriteArray2;
            textureAtlasSpriteArray2[0] = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TextureMap.field_174945_f);
        }
        TextureAtlasSprite[] textures = textureAtlasSpriteArray;
        Baked bm = new Baked(textures[0]);
        for (int i2 = 0; i2 < 7; ++i2) {
            int[] src = this.quads[i2];
            BakedQuad[] dst = new BakedQuad[src.length / 28];
            for (int j = 0; j < dst.length; ++j) {
                int k = j * 28;
                int[] data = Arrays.copyOfRange(src, k, k + 28);
                int t = data[6] >> 24 & 0xFF;
                TextureAtlasSprite texture = textures[t % textures.length];
                for (int l = 0; l < 28; l += 7) {
                    Util.rotate(data, l, orient);
                    data[l + 4] = Float.floatToRawIntBits(texture.func_94214_a((double)Float.intBitsToFloat(data[l + 4])));
                    data[l + 5] = Float.floatToRawIntBits(texture.func_94207_b((double)Float.intBitsToFloat(data[l + 5])));
                    data[l + 6] = hasNormal ? Util.rotateNormal(data[l + 6], orient) : 0;
                }
                dst[j] = new BakedQuad(data, -1, FaceBakery.func_178410_a((int[])data), texture, this.diffuseLight, format);
            }
            if (orient == ModelRotation.X0_Y0 || i2 == 0) {
                ((Baked)bm).quads[i2] = dst;
                continue;
            }
            ((Baked)bm).quads[orient.func_177523_a((EnumFacing)EnumFacing.field_82609_l[i2 - 1]).ordinal() + 1] = dst;
        }
        return bm;
    }

    private int getNormal(double[][] vert, int i) {
        int i0 = i + 3 & 3;
        int i1 = i + 1 & 3;
        double x = vert[i][0];
        double x0 = vert[i0][0] - x;
        double x1 = vert[i1][0] - x;
        double y = vert[i][1];
        double y0 = vert[i0][1] - y;
        double y1 = vert[i1][1] - y;
        double z = vert[i][2];
        double z0 = vert[i0][2] - z;
        double z1 = vert[i1][2] - z;
        x = y1 * z0 - z1 * y0;
        y = z1 * x0 - x1 * z0;
        z = x1 * y0 - y1 * x0;
        double d = 127.0 / Math.sqrt(x * x + y * y + z * z);
        return (byte)(x * d) & 0xFF | ((byte)(y * d) & 0xFF) << 8 | ((byte)(z * d) & 0xFF) << 16;
    }

    private void genNormals(int[] data) {
        int i;
        float[] pos = new float[12];
        for (i = 0; i < 4; ++i) {
            pos[i] = Float.intBitsToFloat(data[i * 7]);
            pos[i | 4] = Float.intBitsToFloat(data[i * 7 + 1]);
            pos[i | 8] = Float.intBitsToFloat(data[i * 7 + 2]);
        }
        for (i = 0; i < 4; ++i) {
            int i0 = i + 3 & 3;
            int i1 = i + 1 & 3;
            float x0 = pos[i0] - pos[i];
            float y0 = pos[i0 | 4] - pos[i | 4];
            float z0 = pos[i0 | 8] - pos[i | 8];
            float x1 = pos[i1] - pos[i];
            float y1 = pos[i1 | 4] - pos[i | 4];
            float z1 = pos[i1 | 8] - pos[i | 8];
            float x = y1 * z0 - z1 * y0;
            float y = z1 * x0 - x1 * z0;
            float z = x1 * y0 - y1 * x0;
            float d = 127.0f / (float)Math.sqrt(x * x + y * y + z * z);
            data[i * 7 + 6] = (byte)(x * d) & 0xFF | ((byte)(y * d) & 0xFF) << 8 | ((byte)(z * d) & 0xFF) << 16;
        }
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    static {
        TRANSFORMS = new String[]{"none", "3PLefthand", "3PRighthand", "1PLefthand", "1PRighthand", "head", "gui", "ground", "fixed"};
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)RawModelData.getTransform(new double[][]{{0.0, 0.0, 0.0}, {0.625, 0.625, 0.625}, {30.0, 225.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)RawModelData.getTransform(new double[][]{{0.0, 3.0, 0.0}, {0.25, 0.25, 0.25}, {0.0, 0.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)RawModelData.getTransform(new double[][]{{0.0, 0.0, 0.0}, {0.5, 0.5, 0.5}, {0.0, 0.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)RawModelData.getTransform(new double[][]{{0.0, 2.5, 0.0}, {0.375, 0.375, 0.375}, {75.0, 45.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)RawModelData.getTransform(new double[][]{{0.0, 2.5, 0.0}, {0.375, 0.375, 0.375}, {75.0, 45.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)RawModelData.getTransform(new double[][]{{0.0, 0.0, 0.0}, {0.4, 0.4, 0.4}, {0.0, 45.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)RawModelData.getTransform(new double[][]{{0.0, 0.0, 0.0}, {0.4, 0.4, 0.4}, {0.0, 225.0, 0.0}}));
        builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)TRSRTransformation.identity());
        builder.put((Object)ItemCameraTransforms.TransformType.NONE, (Object)TRSRTransformation.identity());
        DEFAULT_TRANSFORM = builder.build();
    }

    public class Baked
    implements IPerspectiveAwareModel {
        private final BakedQuad[][] quads = new BakedQuad[7][];
        private final TextureAtlasSprite particle;

        private Baked(TextureAtlasSprite texture) {
            this.particle = texture;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            int i = side == null ? 0 : side.func_176745_a() + 1;
            return this.quads[i] == null ? Collections.emptyList() : Arrays.asList(this.quads[i]);
        }

        public boolean func_177555_b() {
            return RawModelData.this.diffuseLight;
        }

        public boolean func_177556_c() {
            return RawModelData.this.gui3D;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return Pair.of((Object)this, (Object)((TRSRTransformation)RawModelData.this.transform.get((Object)cameraTransformType)).getMatrix());
        }
    }
}

