/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;

public class TextureReplacement
implements IModel {
    public final IModel parent;
    public final ResourceLocation texture;
    private ResourceLocation toReplace;

    public TextureReplacement(IModel parent, ResourceLocation texture) {
        this.parent = parent;
        this.texture = texture;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.parent.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(this.parent.getTextures());
        if (list.isEmpty()) {
            list.add(this.texture);
        } else {
            this.toReplace = list.set(0, this.texture);
        }
        return list;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.parent.bake(state, format, res -> (TextureAtlasSprite)bakedTextureGetter.apply((Object)(res.equals((Object)this.toReplace) ? this.texture : res)));
    }

    public IModelState getDefaultState() {
        return this.parent.getDefaultState();
    }
}

