/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Module;
import cd4017be.lib.script.Parameters;
import java.util.HashMap;
import java.util.function.Function;
import javax.script.ScriptException;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class Context
implements Module {
    private static final Function<Parameters, Object> PRINT = p -> {
        FMLLog.log((String)"RECIPE_SCRIPT", (Level)Level.INFO, (String)"> %s", (Object[])new Object[]{p.get(0)});
        return null;
    };
    private static final Function<Parameters, Object> TIME = p -> (double)System.currentTimeMillis();
    private static final Function<Parameters, Object> REPL = p -> p.getString(0).replaceFirst(p.getString(1), p.getString(2));
    private static final Function<Parameters, Object> CONC = p -> {
        int n = 0;
        for (Object obj : p.param) {
            if (obj instanceof Object[]) {
                n += ((Object[])obj).length;
                continue;
            }
            ++n;
        }
        Object[] vec = new Object[n];
        int j = 0;
        for (int i = 0; i < p.param.length; ++i) {
            Object obj;
            obj = p.param[i];
            if (obj instanceof Object[]) {
                Object[] sub = (Object[])obj;
                System.arraycopy(sub, 0, vec, j, sub.length);
                j += sub.length;
                continue;
            }
            vec[j++] = obj;
        }
        return vec;
    };
    private static final Function<Parameters, Object> NARR = p -> new Object[(int)p.getNumber(0)];
    private static final Function<Parameters, Object> NVEC = p -> new double[(int)p.getNumber(0)];
    public HashMap<String, Module> modules = new HashMap();
    public HashMap<String, Function<Parameters, Object>> defFunc = new HashMap();
    public int recursion = 0;

    public Context() {
        this.defFunc.put("print", PRINT);
        this.defFunc.put("time", TIME);
        this.defFunc.put("repl", REPL);
        this.defFunc.put("conc", CONC);
        this.defFunc.put("narr", NARR);
        this.defFunc.put("nvec", NVEC);
    }

    private String[] split(String name) {
        int p = name.lastIndexOf(46);
        if (p >= 0) {
            return new String[]{name.substring(0, p), name.substring(p + 1)};
        }
        return new String[]{"", name};
    }

    @Override
    public Object invoke(String name, Parameters args) throws NoSuchMethodException, ScriptException {
        String[] s = this.split(name);
        if (s[0] == null) {
            Function<Parameters, Object> f = this.defFunc.get(s[1]);
            if (f != null) {
                return f.apply(args);
            }
        } else {
            Module m = this.modules.get(s[0]);
            if (m != null) {
                return m.invoke(s[1], args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void assign(String name, Object val) {
        String[] s = this.split(name);
        Module m = this.modules.get(s[0]);
        if (m != null) {
            m.assign(s[1], val);
        }
    }

    @Override
    public Object read(String name) {
        String[] s = this.split(name);
        Module m = this.modules.get(s[0]);
        if (m != null) {
            return m.read(s[1]);
        }
        return null;
    }

    public void add(Module m) {
        this.modules.put(m.addToContext(this), m);
    }

    @Override
    public String addToContext(Context cont) {
        return null;
    }

    public void reset() {
        this.recursion = 0;
    }
}

