/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

public class Parameters {
    public final Object[] param;

    public Parameters(Object ... param) {
        this.param = param;
    }

    public String getString(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (o instanceof String) {
            return (String)o;
        }
        throw this.ex("String", o, i);
    }

    public double getNumber(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (o instanceof Double) {
            return (Double)o;
        }
        throw this.ex("Number", o, i);
    }

    public boolean getBool(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (o instanceof Double) {
            return (Boolean)o;
        }
        throw this.ex("Boolean", o, i);
    }

    public Object[] getArray(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        throw this.ex("Array", o, i);
    }

    public double[] getVector(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (o instanceof double[]) {
            return (double[])o;
        }
        throw this.ex("Vector", o, i);
    }

    public <T> T get(int i, Class<T> c) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i];
        if (c.isInstance(o)) {
            return c.cast(o);
        }
        throw this.ex(c.getSimpleName(), o, i);
    }

    public Object get(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        return this.param[i];
    }

    public Object[] getArrayOrAll() {
        if (this.param.length != 1) {
            return this.param;
        }
        Object o = this.param[0];
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        return this.param;
    }

    public double[] getVectorOrAll() {
        Object o;
        if (this.param.length == 1 && (o = this.param[0]) instanceof double[]) {
            return (double[])o;
        }
        double[] vec = new double[this.param.length];
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = this.getNumber(i);
        }
        return vec;
    }

    private IllegalArgumentException num(int pos) {
        return new IllegalArgumentException(String.format("Too few arguments, expected at least %d", pos + 1));
    }

    private IllegalArgumentException ex(String exp, Object got, int pos) {
        return new IllegalArgumentException(String.format("expected %s @ %d , got %s", exp, pos, got == null ? "null" : got.getClass().getSimpleName()));
    }
}

