/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.api.IAbstractTile;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.templates.SharedNetwork;
import cd4017be.lib.util.ICachableInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class MultiblockComp<C extends MultiblockComp<C, N>, N extends SharedNetwork<C, N>>
implements ICachableInstance {
    public N network;
    public final IAbstractTile tile;
    protected long uid;
    public byte con = (byte)63;
    public boolean updateCon;

    public MultiblockComp(IAbstractTile tile) {
        this.tile = tile;
    }

    public long getUID() {
        return this.uid;
    }

    public void setUID(long uid) {
        this.markDirty();
        if (this.uid == uid) {
            return;
        }
        if (this.network != null) {
            MultiblockComp c = (MultiblockComp)((SharedNetwork)this.network).components.remove(this.uid);
            if (c != this) {
                throw new IllegalStateException(String.format("Changing uid of %s into %d, but network had the wrong component %s stored under old uid", this, uid, c));
            }
            ((SharedNetwork)this.network).components.put(uid, this);
        }
        this.uid = uid;
    }

    public void updateCons() {
        if (this.network == null) {
            return;
        }
        for (byte i : ((SharedNetwork)this.network).sides()) {
            C obj;
            if (!this.canConnect(i) || (obj = this.getNeighbor(i)) == null) continue;
            ((SharedNetwork)this.network).add(obj);
        }
        this.updateCon = false;
    }

    public void markDirty() {
        if (!this.updateCon && this.tile instanceof TickRegistry.IUpdatable && !this.tile.isClient()) {
            TickRegistry.instance.updates.add((TickRegistry.IUpdatable)((Object)this.tile));
        }
        this.updateCon = true;
    }

    public boolean canConnect(byte side) {
        return (this.con >> side & 1) != 0;
    }

    public void setConnect(byte side, boolean c) {
        boolean c0 = this.canConnect(side);
        if (!c && c0) {
            ((SharedNetwork)this.network).onDisconnect((MultiblockComp)this, side);
            this.con = (byte)(this.con & ~(1 << side));
        } else if (c && !c0) {
            this.markDirty();
            this.con = (byte)(this.con | 1 << side);
        }
    }

    public C getNeighbor(byte side) {
        ICapabilityProvider te = this.tile.getTileOnSide(EnumFacing.field_82609_l[side]);
        if (te == null) {
            return null;
        }
        MultiblockComp comp = (MultiblockComp)te.getCapability(this.getCap(), EnumFacing.field_82609_l[side ^ 1]);
        return (C)(comp != null && comp.canConnect((byte)(side ^ 1)) ? comp : null);
    }

    public abstract Capability<C> getCap();

    @Override
    public boolean invalid() {
        return this.network == null || this.tile.invalid();
    }

    public String toString() {
        return "MultiblockComp [network=" + (this.network == null ? "none" : Integer.valueOf(((SharedNetwork)this.network).components.size())) + ", tile=" + (this.tile.invalid() ? "invalid " : "") + (this.tile instanceof TileEntity ? ((TileEntity)this.tile).func_174877_v() : this.tile) + ", uid=" + this.uid + ", con=" + this.con + ", update=" + this.updateCon + "]";
    }
}

