/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import java.util.Arrays;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum Orientation implements IStringSerializable
{
    N(EnumFacing.NORTH),
    E(EnumFacing.EAST),
    S(EnumFacing.SOUTH),
    W(EnumFacing.WEST),
    Bn(EnumFacing.DOWN),
    Be(EnumFacing.DOWN),
    Bs(EnumFacing.DOWN),
    Bw(EnumFacing.DOWN),
    Rn(EnumFacing.SOUTH),
    Re(EnumFacing.WEST),
    Rs(EnumFacing.NORTH),
    Rw(EnumFacing.EAST),
    Tn(EnumFacing.UP),
    Te(EnumFacing.UP),
    Ts(EnumFacing.UP),
    Tw(EnumFacing.UP);

    public final EnumFacing front;
    public static final PropertyEnum<Orientation> XY_12_ROT;
    public static final PropertyEnum<Orientation> ALL_AXIS;
    public static final PropertyEnum<Orientation> HOR_AXIS;
    public static final PropertyEnum<Orientation> ALL_AXIS_INV;
    public static final PropertyEnum<Orientation> HOR_AXIS_INV;

    private Orientation(EnumFacing front) {
        this.front = front;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public Orientation reverse() {
        int i = this.ordinal();
        i = (4 - (i >> 2)) % 4 << 2 | (4 - i) % 4;
        return Orientation.values()[i];
    }

    public static Orientation fromFacing(EnumFacing front) {
        switch (front) {
            case DOWN: {
                return Bn;
            }
            case UP: {
                return Tn;
            }
            case SOUTH: {
                return S;
            }
            case WEST: {
                return W;
            }
            case EAST: {
                return E;
            }
        }
        return N;
    }

    public EnumFacing rotate(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return this.front;
        }
        if (dir.func_176740_k() != EnumFacing.Axis.X) {
            if ((this.ordinal() & 4) != 0) {
                dir = dir.func_176732_a(EnumFacing.Axis.X);
            }
            if ((this.ordinal() & 8) != 0) {
                dir = dir.func_176734_d();
            }
        }
        if (dir.func_176740_k() != EnumFacing.Axis.Y) {
            if ((this.ordinal() & 1) != 0) {
                dir = dir.func_176746_e();
            }
            if ((this.ordinal() & 2) != 0) {
                dir = dir.func_176734_d();
            }
        }
        return dir;
    }

    public AxisAlignedBB rotate(AxisAlignedBB box) {
        switch (this.ordinal() >> 2) {
            case 1: {
                box = new AxisAlignedBB(box.field_72340_a, box.field_72339_c, 1.0 - box.field_72337_e, box.field_72336_d, box.field_72334_f, 1.0 - box.field_72338_b);
                break;
            }
            case 2: {
                box = new AxisAlignedBB(box.field_72340_a, 1.0 - box.field_72337_e, 1.0 - box.field_72334_f, box.field_72336_d, 1.0 - box.field_72338_b, 1.0 - box.field_72339_c);
                break;
            }
            case 3: {
                box = new AxisAlignedBB(box.field_72340_a, 1.0 - box.field_72334_f, box.field_72338_b, box.field_72336_d, 1.0 - box.field_72339_c, box.field_72337_e);
            }
        }
        switch (this.ordinal() & 3) {
            case 1: {
                box = new AxisAlignedBB(1.0 - box.field_72334_f, box.field_72338_b, box.field_72340_a, 1.0 - box.field_72339_c, box.field_72337_e, box.field_72336_d);
                break;
            }
            case 2: {
                box = new AxisAlignedBB(1.0 - box.field_72336_d, box.field_72338_b, 1.0 - box.field_72334_f, 1.0 - box.field_72340_a, box.field_72337_e, 1.0 - box.field_72339_c);
                break;
            }
            case 3: {
                box = new AxisAlignedBB(box.field_72339_c, box.field_72338_b, 1.0 - box.field_72336_d, box.field_72334_f, box.field_72337_e, 1.0 - box.field_72340_a);
            }
        }
        return box;
    }

    public Vec3d rotate(Vec3d vec) {
        double z;
        double y;
        double x = vec.field_72450_a;
        switch (this.ordinal() >> 2) {
            case 1: {
                y = vec.field_72449_c;
                z = -vec.field_72448_b;
                break;
            }
            case 2: {
                y = -vec.field_72448_b;
                z = -vec.field_72449_c;
                break;
            }
            case 3: {
                y = -vec.field_72449_c;
                z = vec.field_72448_b;
                break;
            }
            default: {
                y = vec.field_72448_b;
                z = vec.field_72449_c;
            }
        }
        switch (this.ordinal() & 3) {
            case 1: {
                return new Vec3d(-z, y, x);
            }
            case 2: {
                return new Vec3d(-x, y, -z);
            }
            case 3: {
                return new Vec3d(z, y, -x);
            }
        }
        return new Vec3d(x, y, z);
    }

    public Vec3d invRotate(Vec3d vec) {
        double z;
        double x;
        double y = vec.field_72448_b;
        switch (this.ordinal() & 3) {
            case 1: {
                x = vec.field_72449_c;
                z = -vec.field_72450_a;
                break;
            }
            case 2: {
                x = -vec.field_72450_a;
                z = -vec.field_72449_c;
                break;
            }
            case 3: {
                x = -vec.field_72449_c;
                z = vec.field_72450_a;
                break;
            }
            default: {
                x = vec.field_72450_a;
                z = vec.field_72449_c;
            }
        }
        switch (this.ordinal() >> 2) {
            case 1: {
                return new Vec3d(x, -z, y);
            }
            case 2: {
                return new Vec3d(x, -y, -z);
            }
            case 3: {
                return new Vec3d(x, z, -y);
            }
        }
        return new Vec3d(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelRotation getModelRotation() {
        return ModelRotation.values()[this.ordinal()];
    }

    static {
        XY_12_ROT = PropertyEnum.func_177707_a((String)"orient", Orientation.class, Arrays.asList(Bn, Bs, Bw, Be, Tn, Ts, Tw, Te, N, S, W, E));
        ALL_AXIS = PropertyEnum.func_177707_a((String)"orient", Orientation.class, Arrays.asList(Bn, Tn, N, S, W, E));
        HOR_AXIS = PropertyEnum.func_177707_a((String)"orient", Orientation.class, Arrays.asList(N, S, W, E));
        ALL_AXIS_INV = PropertyEnum.func_177707_a((String)"orient", Orientation.class, Arrays.asList(Bs, Ts, Rn, Rs, Rw, Re));
        HOR_AXIS_INV = PropertyEnum.func_177707_a((String)"orient", Orientation.class, Arrays.asList(Rn, Rs, Rw, Re));
    }
}

