/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.wire;

import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.IHookAttachable;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public abstract class RelayPort
extends MountedPort {
    public static final float SIZE = 0.025f;
    public static BiFunction<IHookAttachable, Integer, RelayPort> IMPLEMENTATION;
    public final RelayPort opposite;

    protected RelayPort(IPortProvider owner, int pin) {
        super(owner, pin & 0xFFF | 0x8000, null, true);
        this.opposite = this.createPair();
    }

    protected RelayPort(RelayPort opposite) {
        super(opposite.owner, opposite.pin ^ 0x1000, null, !opposite.isMaster);
        this.opposite = opposite;
    }

    protected abstract RelayPort createPair();

    @Override
    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        RayTraceResult rt = new AxisAlignedBB(this.pos.field_72450_a - (double)0.025f, this.pos.field_72448_b - (double)0.025f, this.pos.field_72449_c - (double)0.025f, this.pos.field_72450_a + (double)0.025f, this.pos.field_72448_b + (double)0.025f, this.pos.field_72449_c + (double)0.025f).func_72327_a(start, start.func_178787_e(dir));
        return rt == null ? null : Pair.of((Object)rt.field_72307_f.func_178788_d(start), (Object)rt.field_178784_b);
    }

    @Override
    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        String s = this.connector != null ? this.connector.displayInfo(this, this.linkID) : (this.opposite.connector != null ? this.opposite.connector.displayInfo(this.opposite, this.linkID) : TooltipUtil.translate(this.name));
        if (!s.isEmpty() && s.charAt(0) == '\n') {
            s = s.substring(1);
        }
        return Pair.of((Object)this.pos, (Object)s);
    }

    public abstract void orient(Orientation var1);

    @Override
    public <T> void addRenderComps(List<T> list, Class<T> type) {
        super.addRenderComps(list, type);
        if (type.isInstance(this.opposite.connector)) {
            list.add(type.cast(this.opposite.connector));
        }
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (hit || player.func_70093_af() && stack.func_190926_b()) {
            if (this.connector != null) {
                this.setConnector(null, player);
            } else if (this.opposite.connector != null) {
                this.opposite.setConnector(null, player);
            } else {
                ((IHookAttachable)this.owner).removeHook(this.pin, player);
            }
            return true;
        }
        if (stack.func_77973_b() instanceof WiredConnector.IWiredConnectorItem) {
            ((WiredConnector.IWiredConnectorItem)stack.func_77973_b()).doAttach(stack, this.connector != null && this.opposite.connector == null ? this.opposite : this, player);
            return true;
        }
        return false;
    }

    @Override
    public void connect(Port to) {
        this.linkID = to.getLink();
        this.owner.onPortModified(this, 1);
    }

    @Override
    public void disconnect() {
        this.linkID = 0;
        this.owner.onPortModified(this, 2);
    }

    @Override
    public void onLoad() {
        if (this.connector != null) {
            this.connector.onLoad();
        }
    }

    @Override
    public void onUnload() {
        if (this.connector != null) {
            this.connector.onUnload();
        }
    }

    public abstract ItemStack getDropped();
}

