/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ClassUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public class ConstantPool {
    public static final short THIS_NAME = 1;
    public static final short THIS_CLASS = 2;
    public static final short SUPER_CLASS = 4;
    public static final short CODE = 5;
    public static final short SUPER_CONSTR = 9;
    public static final int PREINIT_LEN = 10;
    public static final byte[] EMPTY = new byte[0];
    private final ArrayList<byte[]> entries = new ArrayList();
    private int size = 0;
    public static final byte FIELD = 9;
    public static final byte METHOD = 10;
    public static final byte INTERFACE = 11;

    public ConstantPool() {
    }

    public ConstantPool(String name, Class<?> parent) {
        this.add(EMPTY);
        this.putClass(name);
        this.putClass(parent.getName());
        this.add(ConstantPool.constUtf8("Code"));
        this.putFieldMethod(parent, "<init>()V");
    }

    public short add(byte[] entry) {
        ArrayList<byte[]> entries = this.entries;
        int k = entries.size();
        entries.add(entry);
        this.size += entry.length;
        return (short)k;
    }

    public short put(byte[] entry) {
        int k = 0;
        for (byte[] arr : this.entries) {
            if (Arrays.equals(arr, entry)) {
                return (short)k;
            }
            ++k;
        }
        return this.add(entry);
    }

    public void set(int idx, byte[] entry) {
        this.size += entry.length - this.entries.set(idx, entry).length;
    }

    public byte[] get(int idx) {
        return this.entries.get(idx);
    }

    public int getCount() {
        return this.entries.size();
    }

    public int getSize() {
        return this.size;
    }

    public void write(ByteBuffer buf) {
        for (byte[] arr : this.entries) {
            buf.put(arr);
        }
    }

    public void write(byte[] array, int ofs) {
        for (byte[] arr : this.entries) {
            int l = arr.length;
            System.arraycopy(arr, 0, array, ofs, l);
            ofs += l;
        }
    }

    public byte[] toArray() {
        byte[] data = new byte[this.size];
        this.write(data, 0);
        return data;
    }

    private static byte[] constUtf8(String s) {
        byte[] data = s.getBytes(ClassUtils.UTF8);
        int l = data.length;
        byte[] res = new byte[l + 3];
        res[0] = 1;
        res[1] = (byte)(l >> 8);
        res[2] = (byte)l;
        System.arraycopy(data, 0, res, 3, l);
        return res;
    }

    public void setUtf8(int idx, String s) {
        this.set(idx, ConstantPool.constUtf8(s));
    }

    public short putUtf8(String s) {
        return this.put(ConstantPool.constUtf8(s));
    }

    public short putInt(int val) {
        return this.put(new byte[]{3, (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val});
    }

    public short putFloat(float val) {
        int i = Float.floatToIntBits(val);
        return this.put(new byte[]{4, (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i});
    }

    public short putLong(long val) {
        return this.put(new byte[]{5, (byte)(val >> 56), (byte)(val >> 48), (byte)(val >> 40), (byte)(val >> 32), (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val});
    }

    public short putDouble(double val) {
        long i = Double.doubleToLongBits(val);
        return this.put(new byte[]{6, (byte)(i >> 56), (byte)(i >> 48), (byte)(i >> 40), (byte)(i >> 32), (byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i});
    }

    public short putClass(String clsName) {
        short i = this.putUtf8(clsName.replace('.', '/'));
        return this.put(new byte[]{7, (byte)(i >> 8), (byte)i});
    }

    public short putString(String s) {
        short i = this.putUtf8(s);
        return this.put(new byte[]{8, (byte)(i >> 8), (byte)i});
    }

    public short putFieldMethod(Class<?> c, String desc) {
        String type;
        String name;
        byte tag;
        int i = desc.indexOf(40);
        if (i < 0) {
            tag = 9;
            i = desc.indexOf(32);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            name = desc.substring(i + 1);
            type = desc.substring(0, i);
        } else {
            tag = c != null && c.isInterface() ? (byte)11 : 10;
            name = desc.substring(0, i);
            type = desc.substring(i);
        }
        return this.putFieldMethod(c == null ? (short)2 : (short)this.putClass(c.getName()), this.putNameType(name, type), tag);
    }

    public short putFieldMethod(short c, short desc, byte tag) {
        return this.put(new byte[]{tag, (byte)(c >> 8), (byte)c, (byte)(desc >> 8), (byte)desc});
    }

    public short putNameType(String name, String desc) {
        return this.putNameType(this.putUtf8(name), this.putUtf8(desc.replace('.', '/')));
    }

    public short putNameType(short name, short desc) {
        return this.put(new byte[]{12, (byte)(name >> 8), (byte)name, (byte)(desc >> 8), (byte)desc});
    }
}

