/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity.test;

import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.SlotHolo;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Slider;
import cd4017be.lib.capability.AbstractInventory;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.capability.LinkedInventory;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemSupply
extends BaseTileEntity
implements IItemHandler,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler {
    public static int MAX_SLOTS = 64;
    ArrayList<Slot> slots = new ArrayList();
    int scroll;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addFix(1).addMulFix(4, 24).addVar(12);
    @SideOnly(value=Side.CLIENT)
    private static final ResourceLocation TEX = new ResourceLocation("cd4017be_lib", "textures/gui/supply.png");

    public int getSlots() {
        return Math.min(this.slots.size() + 1, MAX_SLOTS);
    }

    public ItemStack getStackInSlot(int slot) {
        return slot < this.slots.size() ? this.slots.get((int)slot).stack : ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < this.slots.size()) {
            Slot s = this.slots.get(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s.stack)) {
                return stack;
            }
            if (!simulate) {
                s.countIn += stack.func_190916_E();
            }
        } else if (!simulate) {
            Slot s = new Slot(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            s.countIn = stack.func_190916_E();
            this.slots.add(s);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.slots.size()) {
            return ItemStack.field_190927_a;
        }
        Slot s = this.slots.get(slot);
        if (!simulate) {
            s.countOut += amount;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)s.stack, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        NBTTagList list = new NBTTagList();
        for (Slot s : this.slots) {
            NBTTagCompound tag = s.stack.func_77955_b(new NBTTagCompound());
            tag.func_74768_a("in", s.countIn);
            tag.func_74768_a("out", s.countOut);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("slots", (NBTBase)list);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        this.slots.clear();
        for (NBTBase tb : nbt.func_150295_c("slots", 10)) {
            NBTTagCompound tag = (NBTTagCompound)tb;
            Slot s = new Slot(new ItemStack(tag));
            s.countIn = tag.func_74762_e("in");
            s.countOut = tag.func_74762_e("out");
            this.slots.add(s);
        }
    }

    private ItemStack getSlot(int slot) {
        return slot + this.scroll < this.slots.size() ? this.slots.get((int)(slot + this.scroll)).stack : ItemStack.field_190927_a;
    }

    private void setSlot(ItemStack stack, int slot) {
        if ((slot += this.scroll) < this.slots.size()) {
            if (stack.func_190926_b()) {
                this.slots.remove(slot);
                return;
            }
            Slot s = this.slots.get(slot);
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s.stack)) {
                s.stack.func_190920_e(stack.func_190916_E());
            } else {
                this.slots.set(slot, new Slot(stack));
            }
        } else if (!stack.func_190926_b()) {
            this.slots.add(new Slot(stack));
        }
    }

    @Override
    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        AdvancedContainer cont = new AdvancedContainer(this, ssb.build(this.field_145850_b.field_72995_K), player);
        AbstractInventory inv = this.field_145850_b.field_72995_K ? new BasicInventory(12) : new LinkedInventory(12, 127, this::getSlot, this::setSlot);
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                cont.addItemSlot((net.minecraft.inventory.Slot)new SlotHolo((IItemHandler)inv, i + j * 3, 8 + i * 54, 16 + j * 18, false, true), true);
            }
        }
        cont.addPlayerInventory(8, 104);
        if (this.field_145850_b.field_72995_K) {
            while (this.slots.size() < 12) {
                this.slots.add(new Slot(ItemStack.field_190927_a));
            }
        }
        return cont;
    }

    @Override
    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.buffer.writeByte(this.scroll);
        int l = this.scroll + 12;
        for (int i = this.scroll; i < l; ++i) {
            if (i < this.slots.size()) {
                Slot s = this.slots.get(i);
                state.buffer.writeInt(s.countIn).writeInt(s.countOut);
                continue;
            }
            state.buffer.writeLong(0L);
        }
        state.endFixed();
    }

    @Override
    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.scroll = state.get(this.scroll);
        for (int i = 0; i < 12; ++i) {
            Slot s = this.slots.get(i);
            s.countIn = state.get(s.countIn);
            s.countOut = state.get(s.countOut);
        }
    }

    @Override
    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @Override
    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        int cmd = pkt.readByte();
        if (cmd < 0) {
            this.scroll = pkt.readUnsignedByte();
            return;
        }
        boolean zero = cmd < 16;
        if ((cmd = (cmd & 0xF) + this.scroll) >= this.slots.size()) {
            return;
        }
        Slot s = this.slots.get(cmd);
        if (zero) {
            s.countIn = 0;
            s.countOut = 0;
        } else if (s.countIn < s.countOut) {
            s.countOut -= s.countIn;
            s.countIn = 0;
        } else {
            s.countIn -= s.countOut;
            s.countOut = 0;
        }
    }

    public ModularGui getGuiScreen(EntityPlayer player, int id) {
        ModularGui gui = new ModularGui(this.getContainer(player, id));
        GuiFrame frame = new GuiFrame(gui, 186, 186, 25).title("gui.cd4017be.item_supp.name", 0.5f).background(TEX, 0, 70);
        new Slider(frame, 8, 12, 70, 170, 16, 176, 0, false, () -> this.scroll, x -> {
            int s = (int)x;
            if (s == this.scroll) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = (byte)-1;
            this.scroll = s;
            objectArray[1] = (byte)this.scroll;
            gui.sendPkt(objectArray);
        }, null, 0.0, MAX_SLOTS - 12).scroll(-3.0f).tooltip("gui.cd4017be.scroll");
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                byte k = (byte)(j * 3 + i);
                new FormatText(frame, 36, 16, 24 + i * 54, 16 + j * 18, "\\\u00a72%d\n\u00a74%d", this.slots.get(k));
                new Button(frame, 36, 16, 24 + i * 54, 16 + j * 18, 0, null, a -> gui.sendPkt(a == 0 ? k : (byte)(k | 0x10))).tooltip("gui.cd4017be.reset_count");
            }
        }
        gui.compGroup = frame;
        return gui;
    }

    public static class Slot
    implements Supplier<Object[]> {
        public final ItemStack stack;
        public int countOut;
        public int countIn;

        public Slot(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public Object[] get() {
            return new Object[]{this.countIn, this.countOut};
        }
    }
}

