/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import cd4017be.api.recipes.ItemOperand;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import java.util.Iterator;
import java.util.ListIterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictStack
implements IOperand {
    public String id;
    public int ID;
    public int stacksize;

    public OreDictStack(String id, int n) {
        this.id = id;
        this.stacksize = n;
        this.ID = OreDictionary.getOreID((String)id);
    }

    public OreDictStack(int id, int n) {
        this.ID = id;
        this.id = OreDictionary.getOreName((int)id);
        this.stacksize = n;
    }

    public static OreDictStack deserialize(String s) {
        int p = s.indexOf(42);
        short n = 1;
        if (p > 0) {
            try {
                n = Short.parseShort(s.substring(0, p));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            s = s.substring(p + 1);
            if (n <= 0) {
                n = 1;
            }
        }
        if (s.isEmpty()) {
            return null;
        }
        return new OreDictStack(s, (int)n);
    }

    public static OreDictStack[] get(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        int[] i = OreDictionary.getOreIDs((ItemStack)item);
        OreDictStack[] stacks = new OreDictStack[i.length];
        for (int j = 0; j < i.length; ++j) {
            stacks[j] = new OreDictStack(i[j], item.func_190916_E());
        }
        return stacks;
    }

    public boolean isEqual(ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
            if (id != this.ID) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getItems() {
        NonNullList list = OreDictionary.getOres((String)this.id);
        ItemStack[] items = new ItemStack[list.size()];
        int n = 0;
        for (ItemStack item : list) {
            items[n] = item.func_77946_l();
            items[n++].func_190920_e(this.stacksize);
        }
        return items;
    }

    public ItemStack asItem() {
        NonNullList list = OreDictionary.getOres((String)this.id);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack item = ((ItemStack)list.get(0)).func_77946_l();
        item.func_190920_e(this.stacksize);
        return item;
    }

    public OreDictStack copy() {
        return new OreDictStack(this.ID, this.stacksize);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IOperand) {
            return this.equals((IOperand)obj);
        }
        if (obj instanceof OreDictStack) {
            OreDictStack stack = (OreDictStack)obj;
            return stack.ID == this.ID;
        }
        return false;
    }

    public int hashCode() {
        return this.ID;
    }

    public String toString() {
        return "ore:" + this.id + (this.stacksize != 1 ? "*" + this.stacksize : "");
    }

    @Override
    public IOperand mulR(IOperand x) {
        return new OreDictStack(this.ID, x.asIndex());
    }

    @Override
    public IOperand mulL(IOperand x) {
        return new OreDictStack(this.ID, x.asIndex());
    }

    @Override
    public IOperand len() {
        return new Number(this.stacksize);
    }

    @Override
    public IOperand grR(IOperand x) {
        if (x instanceof ItemOperand) {
            ItemStack stack = ((ItemOperand)x).stack;
            if (!stack.func_190926_b()) {
                int id = this.ID;
                for (int o : OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (o != id) continue;
                    return Number.TRUE;
                }
            }
            return Number.FALSE;
        }
        if (x instanceof OreDictStack) {
            String ore = ((OreDictStack)x).id;
            if (this.id.equals(ore)) {
                return Number.FALSE;
            }
            NonNullList itemsT = OreDictionary.getOres((String)this.id, (boolean)false);
            NonNullList itemsO = OreDictionary.getOres((String)ore, (boolean)false);
            for (ItemStack stack : itemsT) {
                if (stack.func_190926_b()) continue;
                int meta = stack.func_77960_j();
                Item item = stack.func_77973_b();
                boolean wildcard = meta == Short.MAX_VALUE;
                boolean miss = true;
                for (ItemStack stackO : itemsO) {
                    if (stackO.func_77973_b() != item || !wildcard && stackO.func_77960_j() != meta) continue;
                    miss = false;
                    break;
                }
                if (!miss) continue;
                return Number.FALSE;
            }
            return Number.TRUE;
        }
        return x.grR(this);
    }

    @Override
    public IOperand grL(IOperand x) {
        if (x instanceof ItemOperand) {
            return Number.FALSE;
        }
        return IOperand.super.grL(x);
    }

    @Override
    public IOperand nlsR(IOperand x) {
        return x instanceof OreDictStack ? (((OreDictStack)x).id.equals(this.id) ? Number.TRUE : Number.FALSE) : this.grR(x);
    }

    @Override
    public IOperand nlsL(IOperand x) {
        return x instanceof OreDictStack ? (((OreDictStack)x).id.equals(this.id) ? Number.TRUE : Number.FALSE) : this.grR(x);
    }

    @Override
    public IOperand.OperandIterator iterator() throws Error {
        return new ItemIterator(OreDictionary.getOres((String)this.id).iterator());
    }

    @Override
    public boolean asBool() throws Error {
        return !OreDictionary.getOres((String)this.id, (boolean)false).isEmpty();
    }

    @Override
    public Object value() {
        return this.id;
    }

    public static class ItemIterator
    implements IOperand.OperandIterator {
        final boolean canSet;
        final Iterator<ItemStack> items;

        public ItemIterator(Iterator<ItemStack> items) {
            this.items = items;
            this.canSet = false;
        }

        public ItemIterator(ListIterator<ItemStack> items) {
            this.items = items;
            this.canSet = true;
        }

        @Override
        public boolean hasNext() {
            return this.items.hasNext();
        }

        @Override
        public IOperand next() {
            return new ItemOperand(this.items.next());
        }

        @Override
        public Object value() {
            return this.items;
        }

        @Override
        public void set(IOperand obj) {
            if (this.canSet && obj instanceof ItemOperand) {
                ((ListIterator)this.items).set(((ItemOperand)obj).stack);
            }
        }
    }
}

