/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridPortHolder;
import cd4017be.api.grid.IPortHolder;
import cd4017be.api.grid.IWire;
import cd4017be.api.grid.Link;
import cd4017be.lib.Lib;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.util.Arrays;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ExtGridPorts
implements INBTSerializable<LongArrayNBT> {
    private final IGridPortHolder host;
    private long[] ports = LongArrays.EMPTY_ARRAY;

    public ExtGridPorts(IGridPortHolder host) {
        this.host = host;
    }

    public short getPort(int port) {
        return (short)(this.ports[port] >> 32);
    }

    public boolean isLinked(int port) {
        return this.ports[port] << 1 < 0L;
    }

    public boolean isMaster(int port) {
        return this.ports[port] << 4 < 0L;
    }

    public void onLoad() {
        for (int i = 0; i < this.ports.length; ++i) {
            long x = this.ports[i];
            if (((int)(x >> 60) & 0xD) != 5) continue;
            Link.load(this.host, i, (int)x);
        }
    }

    public void onUnload() {
        for (int i = 0; i < this.ports.length; ++i) {
            long x = this.ports[i];
            if (((int)(x >> 60) & 0xD) != 5) continue;
            Link.unload(this.host, i, (int)x);
        }
    }

    public void onRemove() {
        for (int i = 0; i < this.ports.length; ++i) {
            this.disconnect(i);
        }
    }

    public void clear() {
        for (int i = 0; i < this.ports.length; ++i) {
            this.disconnect(i);
            this.ports[i] = 0L;
        }
    }

    public LongArrayNBT serializeNBT() {
        return new LongArrayNBT(this.ports);
    }

    public void deserializeNBT(LongArrayNBT nbt) {
        this.ports = LongArrays.EMPTY_ARRAY;
        long[] arr = nbt.func_197652_h();
        for (int i = arr.length; i > 0; --i) {
            if (arr[i - 1] == 0L) continue;
            this.ports = Arrays.copyOf(arr, i);
            break;
        }
    }

    public int findPort(short port, int i) {
        if (i < this.ports.length && ExtGridPorts.isPort(this.ports[i], port)) {
            return i;
        }
        for (i = 0; i < this.ports.length; ++i) {
            if (!ExtGridPorts.isPort(this.ports[i], port)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPort(long p, short port) {
        return p >= 0L && (short)(p >> 32) == port;
    }

    public boolean remove(short port) {
        return this.remove(port, true);
    }

    public boolean remove(short port, boolean isWire) {
        int i = this.findPort(port, 255);
        if (i < 0) {
            return false;
        }
        this.disconnect(i);
        if (isWire || this.ports[i] << 2 < 0L) {
            this.ports[i] = 0L;
        } else {
            int n = i;
            this.ports[n] = this.ports[n] & 0xFFFFFFFFFFFFFFFL;
        }
        return true;
    }

    public int create(short port, int flags) {
        int i = this.findPort(port, 255);
        if (i < 0) {
            for (i = 0; i < this.ports.length && this.ports[i] != 0L; ++i) {
            }
            if (i == this.ports.length) {
                this.ports = Arrays.copyOf(this.ports, Math.max(i + 2, i << 1));
            }
        }
        int d = Integer.numberOfTrailingZeros(~port & 0x111);
        d = (d + 8 >> 1 | port >> d + 3 & 1) % 6 | flags << 3;
        this.ports[i] = this.ports[i] & 0x40FF0000FFFFFFFFL | (long)(port & 0xFFFF | d << 24) << 32;
        return i;
    }

    public boolean createPort(short port, boolean master, boolean doLink) {
        int i;
        if (((port | port - 273) & 0x888) != 0) {
            i = this.create(port, master ? 7 : 6);
        } else {
            i = this.findPort(port, 255);
            if (i >= 0) {
                long p = this.ports[i];
                if ((p >>> 60 & 3L) == 1L) {
                    return true;
                }
                this.ports[i] = p & 0x40FFFFFFFFFFFFFFL | (master ? 3L : 2L) << 59;
            } else {
                return false;
            }
        }
        if (doLink) {
            this.connect(i);
        }
        return true;
    }

    public boolean createWire(GridPart part, boolean doLink) {
        IPortHolder.Port p;
        int f1;
        if (!(part instanceof IWire)) {
            return false;
        }
        short port0 = part.ports[0];
        short port1 = part.ports[1];
        int f0 = ((port0 | port0 - 273) & 0x888) != 0 ? 4 : 0;
        int n = f1 = ((port1 | port1 - 273) & 0x888) != 0 ? 4 : 0;
        if ((f0 | f1) == 0) {
            return false;
        }
        int master1 = 0;
        if (f0 == 0 && (p = part.host.findPort(part, port0)) != null) {
            f0 = 2;
            if (!p.isMaster()) {
                master1 = 1;
            }
        }
        if (f1 == 0 && (p = part.host.findPort(part, port1)) != null) {
            f1 = 2;
            if (p.isMaster()) {
                master1 = 1;
            }
        }
        int i0 = this.create(port0, f0 | master1 ^ 1);
        int i1 = this.create(port1, f1 | master1);
        long l0 = this.ports[i0];
        long l1 = this.ports[i1];
        this.ports[i0] = f0 == 4 ? l0 & 0xFFFFFFFF00000000L | (long)ExtGridPorts.mirroredPort(l1) | (long)(i1 << 16) : l0 & 0xFF00FFFFFFFFFFFFL | (long)i1 << 48;
        long l = this.ports[i1] = f1 == 4 ? l1 & 0xFFFFFFFF00000000L | (long)ExtGridPorts.mirroredPort(l0) | (long)(i0 << 16) : l1 & 0xFF00FFFFFFFFFFFFL | (long)i0 << 48;
        if (doLink) {
            this.connect(i0);
        }
        return true;
    }

    private static int mirroredPort(long ep) {
        int ax = (int)(ep >> 57) + 1 & 3;
        return (int)(ep >> 32) & 0xFFFF ^ 8 << (ax == 3 ? 0 : ax << 2);
    }

    public void connect(int extPort) {
        long p = this.ports[extPort];
        if (p < 0L || (p & 0x3000000000000000L) == 0L) {
            return;
        }
        IPortHolder.Port start = this.findStartPort(extPort, true);
        if (start == null) {
            return;
        }
        IPortHolder.Port end = this.findEndPort(extPort, true);
        if (end == null || !(start.isMaster() ^ end.isMaster())) {
            return;
        }
        long[] startPorts = ((IGridPortHolder)start.host).extPorts().ports;
        long[] endPorts = ((IGridPortHolder)end.host).extPorts().ports;
        long se = startPorts[start.channel];
        long ee = endPorts[end.channel];
        int id = (int)se;
        if (id == 0 || id != (int)ee) {
            id = Link.newId();
        }
        startPorts[start.channel] = se & 0xFFFFFFFF00000000L | (long)id & 0xFFFFFFFFL | 0x4000000000000000L;
        endPorts[end.channel] = ee & 0xFFFFFFFF00000000L | (long)id & 0xFFFFFFFFL | 0x4000000000000000L;
        Link.load(start.host, start.channel, id);
        Link.load(end.host, end.channel, id);
    }

    public void disconnect(int extPort) {
        long[] ports;
        if ((this.ports[extPort] >> 62 & 3L) != 1L) {
            return;
        }
        IPortHolder.Port port = this.findStartPort(extPort, false);
        if (port != null) {
            ports = ((IGridPortHolder)port.host).extPorts().ports;
            Link.unload(port.host, port.channel, (int)ports[port.channel]);
            int n = port.channel;
            ports[n] = ports[n] & 0xBFFFFFFFFFFFFFFFL;
        }
        if ((port = this.findEndPort(extPort, false)) != null) {
            ports = ((IGridPortHolder)port.host).extPorts().ports;
            Link.unload(port.host, port.channel, (int)ports[port.channel]);
            int n = port.channel;
            ports[n] = ports[n] & 0xBFFFFFFFFFFFFFFFL;
        }
    }

    private IPortHolder.Port findStartPort(int i, boolean linked) {
        long ep = this.ports[i];
        if (ep << 2 >= 0L) {
            i = (int)(ep >> 48) & 0xFF;
        } else if (ep << 3 >= 0L) {
            i = (int)ep >>> 16;
        } else {
            return new IPortHolder.Port(this.host, i);
        }
        return this.findEndPort(i, linked);
    }

    private ExtGridPorts adjacent(int dir) {
        BlockPos pos = this.host.pos().func_177972_a(Direction.func_82600_a((int)dir));
        TileEntity te = this.host.world().func_175625_s(pos);
        return te instanceof IGridPortHolder ? ((IGridPortHolder)te).extPorts() : null;
    }

    private IPortHolder.Port findEndPort(int i, boolean linked) {
        long ep = this.ports[i];
        long link = linked ? 0x4000000000000000L : 0L;
        short port = (short)ExtGridPorts.mirroredPort(ep);
        ExtGridPorts grid0 = this;
        while (ep << 2 < 0L) {
            ExtGridPorts grid1 = grid0.adjacent((int)(ep >> 56) & 7);
            if (grid1 == null) {
                return null;
            }
            int p = grid1.findPort(port, (int)(ep >> 48) & 0xFF);
            if (p < 0) {
                return null;
            }
            grid0.ports[i] = ep & 0x3F00FFFFFFFFFFFFL | (long)p << 48 | link & (ep ^ 0xFFFFFFFFFFFFFFFFL) << 2;
            grid0 = grid1;
            ep = grid0.ports[p];
            if (ep << 3 < 0L) {
                return new IPortHolder.Port(grid0.host, p);
            }
            grid0.ports[p] = ep & 0x3F00FFFFFFFFFFFFL | (long)i << 48 | link;
            port = (short)ep;
            i = (int)ep >> 16 & 0xFF;
            if (i >= grid0.ports.length) {
                Lib.LOG.error("link index out of bounds: {x}", (Object)ep);
                return null;
            }
            ep = grid0.ports[i];
        }
        return ep << 3 < 0L ? new IPortHolder.Port(grid0.host, i) : null;
    }
}

