/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid;

import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.IPortHolder;
import cd4017be.lib.network.INBTSynchronized;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.math.Orient;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class GridPart
implements IPortHolder,
INBTSynchronized {
    public IGridHost host;
    public long bounds;
    public short[] ports;
    public static BlockState GRID_HOST_BLOCK;
    public static final byte L_OUTER = 1;
    public static final byte L_INNER = -1;
    public static final byte L_FULL = 0;
    public static final long[] FACES;

    public GridPart(int ports) {
        this.ports = ports == 0 ? ShortArrays.EMPTY_ARRAY : new short[ports];
    }

    public abstract Item item();

    public ItemStack asItemStack() {
        return new ItemStack((IItemProvider)this.item());
    }

    public GridPart setHost(IGridHost host) {
        this.host = host;
        return this;
    }

    public void setBounds(long b) {
        long old = this.bounds;
        this.bounds = b;
        this.host.updateBounds();
        for (int i = 0; i < 6; ++i) {
            Direction d;
            long f = FACES[i];
            if ((old & f) != 0L ^ (b & f) == 0L || this.analogOutput(d = Direction.func_82600_a((int)(i ^ 1))) <= 0) continue;
            this.host.updateNeighbor(d.func_176734_d());
        }
        this.host.onPartChange();
    }

    public byte getLayer() {
        return 0;
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        INBTSynchronized.super.storeState(nbt, mode);
        nbt.func_74778_a("id", this.item().getRegistryName().toString());
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand != null) {
            return ActionResultType.PASS;
        }
        if (!player.field_70170_p.field_72995_K && player.func_184614_ca().func_77973_b() instanceof IGridItem) {
            IGridHost host = this.host;
            host.removePart(this);
            host.removeIfEmpty();
            if (!player.func_184812_l_()) {
                ItemFluidUtil.dropStack(this.asItemStack(), (Entity)player);
            }
        }
        return ActionResultType.CONSUME;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void fillModel(JitBakedModel var1, long var2);

    public int analogOutput(Direction side) {
        return 0;
    }

    public boolean connectRedstone(Direction side) {
        return false;
    }

    public void onBlockChange(World world, BlockPos pos, Direction dir) {
    }

    public void onTEChange(World world, BlockPos pos, Direction dir) {
    }

    public boolean dissassemble(World world, BlockPos pos) {
        return false;
    }

    public boolean merge(IGridHost other) {
        return true;
    }

    public boolean canRotate() {
        return false;
    }

    public void rotate(int steps) {
        int idz;
        int idx;
        int i;
        long b = this.bounds;
        long b1 = 0L;
        switch (steps & 3) {
            case 1: {
                i = 3;
                idx = 16;
                idz = -65;
                break;
            }
            case 2: {
                i = 51;
                idx = -1;
                idz = -12;
                break;
            }
            case 3: {
                i = 48;
                idx = -16;
                idz = 65;
                break;
            }
            default: {
                return;
            }
        }
        int z = 0;
        while (z < 4) {
            int x = 0;
            while (x < 4) {
                b1 |= (b & 0x1111L) << i;
                ++x;
                b >>>= 1;
                i += idx;
            }
            ++z;
            b >>>= 12;
            i += idz;
        }
        this.bounds = b1;
    }

    public boolean canMove(Direction d, int n) {
        return false;
    }

    public GridPart move(Direction d, int n) {
        int id = d.ordinal();
        int s = GridPart.step(id);
        long b0 = this.bounds;
        long b1 = b0 & GridPart.mask(id, n);
        b0 &= b1 ^ 0xFFFFFFFFFFFFFFFFL;
        if ((id & 1) == 0) {
            b0 >>>= s * n;
            b1 <<= s * (4 - n);
        } else {
            b0 <<= s * n;
            b1 >>>= s * (4 - n);
        }
        if (b0 == 0L) {
            this.bounds = b1;
            return this;
        }
        this.bounds = b0;
        if (b1 == 0L) {
            return null;
        }
        return this.copy(b1);
    }

    protected GridPart copy(long bounds) {
        return null;
    }

    public static short port(int pos, Direction dir, int type) {
        return (short)((pos << 1 & 6 | pos << 3 & 0x60 | pos << 5 & 0x600 | type << 12) + 273 + (dir.func_82601_c() | dir.func_96559_d() << 4 | dir.func_82599_e() << 8));
    }

    public static long bounds(int p0, int p1) {
        int i;
        long b = 1L << p0;
        if (p1 == p0) {
            return b;
        }
        for (i = (p1 & 3) - (p0 & 3); i > 0; --i) {
            b |= b << 1;
        }
        while (i < 0) {
            b |= b >>> 1;
            ++i;
        }
        for (i = (p1 & 0xC) - (p0 & 0xC) >> 2; i > 0; --i) {
            b |= b << 4;
        }
        while (i < 0) {
            b |= b >>> 4;
            ++i;
        }
        for (i = (p1 & 0x30) - (p0 & 0x30) >> 4; i > 0; --i) {
            b |= b << 16;
        }
        while (i < 0) {
            b |= b >>> 16;
            ++i;
        }
        return b;
    }

    public static long floodFill(long b, long f) {
        f &= b;
        while (f != (f |= GridPart.outline(f) & b)) {
        }
        return f;
    }

    public static long outline(long b) {
        return b << 1 & 0xEEEEEEEEEEEEEEEEL | b >> 1 & 0x7777777777777777L | b << 4 & 0xFFF0FFF0FFF0FFF0L | b >> 4 & 0xFFF0FFF0FFF0FFFL | b << 16 & 0xFFFFFFFFFFFF0000L | b >> 16 & 0xFFFFFFFFFFFFL;
    }

    public static int step(int dir) {
        return 46116 >>> dir * 3 & 0x15;
    }

    public static long mask(int dir, int n) {
        long m = FACES[dir];
        if (n == 1) {
            return m;
        }
        int s = GridPart.step(dir);
        if ((dir & 1) != 0) {
            m >>>= s * (n - 1);
        }
        while (--n > 0) {
            m |= m << s;
        }
        return m;
    }

    public static float[] vec(int pos) {
        return new float[]{pos & 3, pos >> 2 & 3, pos >> 4 & 3};
    }

    public static void rotate(short[] ports, int steps) {
        int o = Orient.rot(1, steps);
        int sign = (o & 0x111) * 15;
        for (int i = 0; i < ports.length; ++i) {
            int p = ports[i];
            p = (p ^ sign) - (sign & 0x777);
            ports[i] = (short)(p & 0xF000 | (p & 0xF) << (o << 1 & 0xC) | (p >> 4 & 0xF) << (o >> 3 & 0xC) | (p >> 8 & 0xF) << (o >> 7 & 0xC));
        }
    }

    public static void move(short[] ports, Direction d, int n, boolean newBlock) {
        if (ports.length == 0) {
            return;
        }
        int ofs = (d.func_82601_c() * n + 4 << 1 | d.func_96559_d() * n + 4 << 5 | d.func_82599_e() * n + 4 << 9) & 0x777;
        int m = (d.ordinal() & 1 ^ (newBlock ? 0 : 1)) << d.func_176740_k().ordinal() * 4 + 3;
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (short)(ports[i] + ofs ^ m);
        }
    }

    public static GridPart load(GridPart part, CompoundNBT nbt, int mode) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("id")));
        if (part == null || part.item() != item) {
            GridPart gridPart = part = item instanceof IGridItem ? ((IGridItem)item).createPart() : null;
        }
        if (part != null) {
            part.loadState(nbt, mode);
        }
        return part;
    }

    static {
        FACES = new long[]{0xF000F000F000FL, -1152657617789587456L, 65535L, -281474976710656L, 0x1111111111111111L, -8608480567731124088L};
    }
}

