/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.IGridPortHolder;
import cd4017be.api.grid.IPortHolder;
import cd4017be.math.Linalg;
import cd4017be.math.MCConv;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;

public interface IGridHost
extends IGridPortHolder {
    public GridPart findPart(Predicate<GridPart> var1);

    public IPortHolder.Port findPort(GridPart var1, short var2);

    public void removePart(GridPart var1);

    public boolean addPart(GridPart var1);

    public void onPartChange();

    public void updateBounds();

    public void removeIfEmpty();

    public void updateNeighbor(Direction var1);

    public long bounds();

    public void updateDisplay();

    @Override
    default public Object getHandler(int port) {
        IPortHolder.Port p = this.findPort(null, this.extPorts().getPort(port));
        return p != null ? p.getHandler() : null;
    }

    @Override
    default public void setHandler(int port, Object handler) {
        IPortHolder.Port p = this.findPort(null, this.extPorts().getPort(port));
        if (p != null) {
            p.setHandler(handler);
        }
    }

    default public GridPart getPart(int pos, byte layer) {
        long m = 1L << pos;
        return this.findPart(p -> (p.bounds & m) != 0L && (layer == 0 || layer + p.getLayer() != 0));
    }

    default public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        int pos = IGridHost.target(hit, false);
        if (pos >= 0) {
            ActionResultType res;
            GridPart part = this.getPart(pos, (byte)1);
            if (part == null) {
                part = this.getPart(pos, (byte)-1);
            }
            if (part != null && (res = part.onInteract(player, hand, hit, pos)).func_226246_a_()) {
                return res;
            }
        }
        ItemStack stack = player.func_184586_b(hand == null ? Hand.MAIN_HAND : hand);
        return stack.func_77973_b() instanceof IGridItem ? ((IGridItem)stack.func_77973_b()).onInteract(this, stack, player, hand, hit) : ActionResultType.PASS;
    }

    public static int target(BlockRayTraceResult hit, boolean adjacent) {
        float[] vec = Linalg.sca(3, MCConv.blockRelVecF(hit.func_216347_e(), hit.func_216350_a()), 4.0f);
        Linalg.add(3, vec, MCConv.dirVecF(hit.func_216354_b(), adjacent ? 0.5f : -0.5f));
        if (!Linalg.allInRange(3, vec, 0.0f, 4.0f)) {
            return -1;
        }
        return (int)vec[0] | (int)vec[1] << 2 | (int)vec[2] << 4;
    }

    public static int posOfport(int port) {
        if ((port & 0x888) != 0) {
            return -1;
        }
        return port >> 1 & 3 | port >> 3 & 0xC | port >> 5 & 0x30;
    }
}

