/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid;

public interface IPortHolder {
    public Object getHandler(int var1);

    public void setHandler(int var1, Object var2);

    public boolean isMaster(int var1);

    public static class Port {
        public final IPortHolder host;
        public final int channel;

        public Port(IPortHolder host, int channel) {
            this.host = host;
            this.channel = channel;
        }

        public boolean isMaster() {
            return this.host.isMaster(this.channel);
        }

        public void setHandler(Object handler) {
            this.host.setHandler(this.channel, handler);
        }

        public Object getHandler() {
            return this.host.getHandler(this.channel);
        }

        public boolean connect(Port other) {
            boolean master = this.isMaster();
            if (!master ^ other.isMaster()) {
                return false;
            }
            if (master) {
                this.setHandler(other.getHandler());
            } else {
                other.setHandler(this.getHandler());
            }
            return true;
        }

        public String toString() {
            return this.host + "[" + this.channel + "]";
        }
    }
}

