/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid;

import cd4017be.api.grid.IPortHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.fml.WorldPersistenceHooks;

public class Link {
    private IPortHolder provider;
    private IPortHolder master;
    private int providerPort;
    private int masterPort;
    private static final Int2ObjectOpenHashMap<Link> LINKS = new Int2ObjectOpenHashMap();
    private static int NEXT_ID;
    public static int REC_FLUID;
    public static int REC_ITEM;
    public static int REC_POWER;
    public static int REC_DATA;
    public static int REC_BLOCK;

    private Link(int id) {
    }

    private void load(IPortHolder obj, int port) {
        if (obj.isMaster(port)) {
            this.master = obj;
            this.masterPort = port;
        } else {
            this.provider = obj;
            this.providerPort = port;
        }
        if (this.provider != null && this.master != null) {
            this.master.setHandler(this.masterPort, this.provider.getHandler(this.providerPort));
        }
    }

    private boolean unload(IPortHolder obj, int port) {
        if (obj.isMaster(port)) {
            obj.setHandler(port, null);
            if (this.master == obj && this.masterPort == port) {
                this.master = null;
                if (this.provider == null) {
                    return true;
                }
            }
        } else if (this.provider == obj && this.providerPort == port) {
            this.provider = null;
            if (this.master == null) {
                return true;
            }
            this.master.setHandler(this.masterPort, null);
        }
        return false;
    }

    public static void clear() {
        LINKS.clear();
        NEXT_ID = 0;
    }

    public static int newId() {
        return NEXT_ID++;
    }

    public static void load(IPortHolder obj, int port, int linkId) {
        ((Link)LINKS.computeIfAbsent(linkId, Link::new)).load(obj, port);
    }

    public static void unload(IPortHolder obj, int port, int linkId) {
        Link l = (Link)LINKS.get(linkId);
        if (l != null && l.unload(obj, port)) {
            LINKS.remove(linkId);
        }
    }

    static {
        WorldPersistenceHooks.addHook((WorldPersistenceHooks.WorldPersistenceHook)new WorldPersistenceHooks.WorldPersistenceHook(){

            public String getModId() {
                return "cd4017be_lib";
            }

            public CompoundNBT getDataForWriting(SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("nextLink", NEXT_ID);
                return nbt;
            }

            public void readData(SaveFormat.LevelSave levelSave, IServerConfiguration serverInfo, CompoundNBT tag) {
                NEXT_ID = tag.func_74762_e("nextLink");
            }
        });
        REC_FLUID = 8;
        REC_ITEM = 8;
        REC_POWER = 2;
        REC_DATA = 4;
        REC_BLOCK = 4;
    }
}

