/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.grid.port;

import cd4017be.api.grid.Link;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public interface IInventoryAccess
extends ToIntFunction<ItemStack> {
    public static final IInventoryAccess NOP = new IInventoryAccess(){

        @Override
        public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        }

        @Override
        public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
            return 0;
        }

        @Override
        public int insert(ItemStack stack, int rec) {
            return 0;
        }
    };
    public static final int TYPE_ID = 2;

    default public void getContent(ObjIntConsumer<ItemStack> inspector) {
        this.getContent(inspector, Link.REC_ITEM);
    }

    public void getContent(ObjIntConsumer<ItemStack> var1, int var2);

    default public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target) {
        return this.transfer(amount, filter, target, Link.REC_ITEM);
    }

    public int transfer(int var1, Predicate<ItemStack> var2, ToIntFunction<ItemStack> var3, int var4);

    @Override
    default public int applyAsInt(ItemStack stack) {
        return this.insert(stack, Link.REC_ITEM);
    }

    public int insert(ItemStack var1, int var2);

    public static IInventoryAccess of(Object handler) {
        return handler instanceof IInventoryAccess ? (IInventoryAccess)handler : NOP;
    }

    public static Predicate<ItemStack> filter(ItemStack stack) {
        return s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack);
    }
}

