/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.block;

import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockTE<T extends TileEntity>
extends Block {
    public TileEntityType<T> tileType;
    public final int handlerFlags;
    public static final String TE_TAG = "BlockEntityTag";
    public static final int H_BREAK = 1;
    public static final int H_NEIGHBOR = 2;
    public static final int H_UPDATE = 4;
    public static final int H_INTERACT = 8;
    public static final int H_COLLIDE = 16;
    public static final int H_REDSTONE = 32;
    public static final int H_COMPARATOR = 64;
    public static final int H_DROPS = 128;
    public static final int H_GUI = 256;
    public static final int H_SHAPE = 512;
    public static final int H_ITEMDATA = 1024;
    public static final int H_PLACE = 2048;

    public BlockTE(AbstractBlock.Properties properties, int flags) {
        super(properties);
        this.handlerFlags = flags;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (!this.hasTileEntity(state)) {
            return null;
        }
        TileEntity te = this.tileType.func_200968_a();
        if (te instanceof BaseTileEntity) {
            ((BaseTileEntity)te).unloaded = false;
        }
        return te;
    }

    public TileEntityType<T> makeTEType(Function<TileEntityType<T>, T> factory) {
        return BlockTE.makeTEType(factory, this);
    }

    @SafeVarargs
    public static <T extends TileEntity> TileEntityType<T> makeTEType(Function<TileEntityType<T>, T> factory, BlockTE<T> ... blocks) {
        BlockTE<T> block = blocks[0];
        TileEntityType type = TileEntityType.Builder.func_223042_a(() -> (TileEntity)factory.apply(block.tileType), (Block[])blocks).func_206865_a(null);
        type.setRegistryName(block.getRegistryName());
        for (BlockTE<T> b : blocks) {
            b.tileType = type;
        }
        return type;
    }

    private final <I> void handleTE(BlockState state, int event, IWorldReader world, BlockPos pos, Class<I> type, Consumer<I> action) {
        if ((this.handlerFlags & event) == 0 || !this.hasTileEntity(state)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (type.isInstance(te)) {
            action.accept(type.cast(te));
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.handleTE(state, 1, (IWorldReader)world, pos, ITEBreak.class, te -> te.onBreak(newState, isMoving));
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.handleTE(state, 2, world, pos, ITENeighborChange.class, te -> te.onNeighborTEChange(neighbor));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.handleTE(state, 4, (IWorldReader)world, pos, ITEBlockUpdate.class, te -> te.onNeighborBlockChange(fromPos, block, isMoving));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.hasTileEntity(state)) {
            return ActionResultType.PASS;
        }
        if ((this.handlerFlags & 8) != 0) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof ITEInteract ? ((ITEInteract)te).onActivated(player, hand, hit) : ActionResultType.PASS;
        }
        INamedContainerProvider ncp = this.func_220052_b(state, world, pos);
        if (ncp == null) {
            return ActionResultType.PASS;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            return ActionResultType.SUCCESS;
        }
        ServerPlayerEntity splayer = (ServerPlayerEntity)player;
        if (ncp instanceof ISpecialContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)splayer, (INamedContainerProvider)ncp, (Consumer)((ISpecialContainerProvider)ncp));
        } else {
            NetworkHooks.openGui((ServerPlayerEntity)splayer, (INamedContainerProvider)ncp, (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        this.handleTE(state, 8, (IWorldReader)world, pos, ITEInteract.class, te -> te.onClicked(player));
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        this.handleTE(state, 16, (IWorldReader)world, pos, ITECollision.class, te -> te.onEntityCollided(entity));
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        this.handleTE(state, 16, (IWorldReader)world, hit.func_216350_a(), ITECollision.class, te -> te.onProjectileCollided(projectile, hit));
    }

    public boolean func_149744_f(BlockState state) {
        return (this.handlerFlags & 0x20) != 0 && this.hasTileEntity(state);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return !this.func_149744_f(state) && super.shouldCheckWeakPower(state, world, pos, side);
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (!this.func_149744_f(state)) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ITERedstone ? ((ITERedstone)te).redstoneSignal(side, false) : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        if (!this.func_149744_f(state)) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ITERedstone ? ((ITERedstone)te).redstoneSignal(side, true) : 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (!this.func_149744_f(state)) {
            return false;
        }
        if (side == null) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ITERedstone && ((ITERedstone)te).redstoneConnection(side);
    }

    public boolean func_149740_M(BlockState state) {
        return (this.handlerFlags & 0x40) != 0 && this.hasTileEntity(state);
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        if (!this.func_149740_M(state)) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ITEComparator ? ((ITEComparator)te).comparatorSignal() : 0;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        if ((this.handlerFlags & 0x100) == 0 || !this.hasTileEntity(state)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return te instanceof INamedContainerProvider ? (INamedContainerProvider)te : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te;
        if ((this.handlerFlags & 0x200) != 0 && this.hasTileEntity(state) && (te = world.func_175625_s(pos)) instanceof ITEShape) {
            return ((ITEShape)te).getShape(context);
        }
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te;
        if ((this.handlerFlags & 0x400) != 0 && this.hasTileEntity(state) && (te = world.func_175625_s(pos)) instanceof ITEPickItem) {
            return ((ITEPickItem)te).getPickItem((BlockRayTraceResult)target, player);
        }
        return new ItemStack((IItemProvider)this);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if ((this.handlerFlags & 0x400) != 0 && this.hasTileEntity(state)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ITEPickItem) {
                return ((ITEPickItem)te).getItem();
            }
            if (te != null) {
                te.func_189515_b(stack.func_190925_c(TE_TAG));
            }
        }
        return stack;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack stack;
        super.func_176208_a(world, pos, state, player);
        if (world.field_72995_K || !player.func_184812_l_()) {
            return;
        }
        if ((this.handlerFlags & 0x400) == 0 || !this.hasTileEntity(state)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return;
        }
        if (te instanceof ITEPickItem) {
            stack = ((ITEPickItem)te).getItem();
            if (!stack.func_77942_o()) {
                return;
            }
        } else {
            stack = new ItemStack((IItemProvider)this);
            CompoundNBT nbt = te.func_189515_b(stack.func_190925_c(TE_TAG));
            nbt.func_82580_o("id");
            nbt.func_82580_o("x");
            nbt.func_82580_o("y");
            nbt.func_82580_o("z");
        }
        ItemFluidUtil.dropStack(stack, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        this.handleTE(state, 2048, (IWorldReader)world, pos, ITEPlace.class, te -> te.onPlace(state, stack, entity));
    }

    public static int flags(Class<?> c) {
        int f = 0;
        if (ITEBreak.class.isAssignableFrom(c)) {
            f |= 1;
        }
        if (ITENeighborChange.class.isAssignableFrom(c)) {
            f |= 2;
        }
        if (ITEBlockUpdate.class.isAssignableFrom(c)) {
            f |= 4;
        }
        if (ITEInteract.class.isAssignableFrom(c)) {
            f |= 8;
        }
        if (ITECollision.class.isAssignableFrom(c)) {
            f |= 0x10;
        }
        if (ITERedstone.class.isAssignableFrom(c)) {
            f |= 0x20;
        }
        if (ITEComparator.class.isAssignableFrom(c)) {
            f |= 0x40;
        }
        if (INamedContainerProvider.class.isAssignableFrom(c)) {
            f |= 0x100;
        }
        if (ITEShape.class.isAssignableFrom(c)) {
            f |= 0x200;
        }
        if (ITEPickItem.class.isAssignableFrom(c)) {
            f |= 0x400;
        }
        if (ITEPlace.class.isAssignableFrom(c)) {
            f |= 0x800;
        }
        return f;
    }

    public static interface ITEPlace {
        public void onPlace(BlockState var1, ItemStack var2, LivingEntity var3);
    }

    public static interface ITEPickItem {
        public ItemStack getItem();

        default public ItemStack getPickItem(BlockRayTraceResult target, PlayerEntity player) {
            return this.getItem();
        }
    }

    public static interface ITEShape {
        public VoxelShape getShape(ISelectionContext var1);
    }

    public static interface ISpecialContainerProvider
    extends Consumer<PacketBuffer>,
    IUnnamedContainerProvider {
        @Override
        public void accept(PacketBuffer var1);
    }

    public static interface ITEComparator {
        public int comparatorSignal();
    }

    public static interface ITERedstone {
        public int redstoneSignal(Direction var1, boolean var2);

        public boolean redstoneConnection(@Nullable Direction var1);
    }

    public static interface ITECollision {
        public void onEntityCollided(Entity var1);

        default public void onProjectileCollided(ProjectileEntity projectile, BlockRayTraceResult hit) {
        }
    }

    public static interface ITEInteract {
        public ActionResultType onActivated(PlayerEntity var1, Hand var2, BlockRayTraceResult var3);

        public void onClicked(PlayerEntity var1);
    }

    public static interface ITEBlockUpdate {
        public void onNeighborBlockChange(BlockPos var1, Block var2, boolean var3);
    }

    public static interface ITENeighborChange {
        public void onNeighborTEChange(BlockPos var1);
    }

    public static interface ITEBreak {
        public void onBreak(BlockState var1, boolean var2);
    }
}

