/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.capability.AbstractInventory;
import cd4017be.lib.capability.IFluidHandlerModifiable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class AdvancedTank
extends AbstractInventory
implements IFluidHandlerModifiable {
    public final TileEntity tile;
    public FluidStack fluid;
    public ItemStack cont;
    public final boolean fixed;
    public boolean output;
    public boolean lock;
    public int cap;
    private int need;

    public AdvancedTank(TileEntity tile, int cap, boolean out) {
        this(tile, cap, out, null);
    }

    public AdvancedTank(TileEntity tile, int cap, boolean out, Fluid type) {
        this.tile = tile;
        this.cap = cap;
        this.output = out;
        this.need = out ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        this.lock = this.fixed = type != null;
        this.fluid = this.fixed ? new FluidStack(type, 0) : FluidStack.EMPTY;
        this.cont = ItemStack.field_190927_a;
    }

    public void setLock(boolean lock) {
        if (this.fixed) {
            return;
        }
        if (lock) {
            this.lock = !this.fluid.isEmpty();
        } else {
            this.lock = false;
            if (this.fluid.isEmpty()) {
                this.fluid = FluidStack.EMPTY;
            }
        }
    }

    public void setOut(boolean out) {
        if (out != this.output) {
            this.output = out;
            if (out) {
                this.fillContainer();
            } else {
                this.drainContainer();
            }
        }
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.cont = stack;
        if (!this.tile.func_145830_o() || this.tile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.output) {
            this.fillContainer();
        } else {
            this.drainContainer();
        }
        this.tile.func_70296_d();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.cont;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return this.cap;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.fluid = stack;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return !this.fixed || this.fluid.isFluidEqual(stack);
    }

    public int fill(FluidStack res, IFluidHandler.FluidAction action) {
        if (this.fluid.getRawFluid() == Fluids.field_204541_a) {
            int m = Math.min(res.getAmount(), this.cap);
            if (action.execute()) {
                this.fluid = new FluidStack(res, m);
                if (this.output && m >= this.need) {
                    this.fillContainer();
                }
                this.tile.func_70296_d();
            }
            return m;
        }
        if (this.fluid.isFluidEqual(res)) {
            int m = Math.min(res.getAmount(), this.cap - this.fluid.getAmount());
            if (m != 0 && action.execute()) {
                this.increment(m);
            }
            return m;
        }
        return 0;
    }

    public FluidStack drain(FluidStack res, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty() || !this.fluid.isFluidEqual(res)) {
            return FluidStack.EMPTY;
        }
        int m = Math.min(res.getAmount(), this.fluid.getAmount());
        FluidStack ret = new FluidStack(this.fluid, m);
        if (action.execute()) {
            this.decrement(m);
        }
        return ret;
    }

    public FluidStack drain(int m, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fluid.getAmount() < m) {
            m = this.fluid.getAmount();
        }
        FluidStack ret = new FluidStack(this.fluid, m);
        if (action.execute()) {
            this.decrement(m);
        }
        return ret;
    }

    public int amount() {
        return this.fluid.getAmount();
    }

    public int free() {
        return this.cap - this.fluid.getAmount();
    }

    public void increment(int n) {
        this.fluid.setAmount(n += this.fluid.getAmount());
        if (this.output && n >= this.need) {
            this.fillContainer();
        }
        this.tile.func_70296_d();
    }

    public void decrement(int n) {
        n = this.fluid.getAmount() - n;
        this.fluid.setAmount(n);
        if (n <= 0 && !this.lock) {
            this.fluid = FluidStack.EMPTY;
        }
        if (!this.output && n <= this.need) {
            this.drainContainer();
        }
        this.tile.func_70296_d();
    }

    public void fillContainer() {
        this.need = Integer.MAX_VALUE;
        if (this.cont.func_190916_E() == 0) {
            return;
        }
        if (this.fluid.getRawFluid() == Fluids.field_204541_a) {
            this.need = 0;
            return;
        }
        this.cont.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(acc -> {
            this.fluid.shrink(acc.fill(this.fluid, IFluidHandler.FluidAction.EXECUTE));
            int n = this.fluid.getAmount();
            int m = acc.fill(new FluidStack(this.fluid, this.cap), IFluidHandler.FluidAction.SIMULATE);
            if (m > 0) {
                this.need = m;
            }
            if (n <= 0 && !this.lock) {
                this.fluid = FluidStack.EMPTY;
            }
            this.cont = acc.getContainer();
        });
    }

    public void drainContainer() {
        this.need = Integer.MIN_VALUE;
        this.cont.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(acc -> {
            FluidStack res;
            if (this.fluid.getRawFluid() == Fluids.field_204541_a) {
                this.fluid = acc.drain(this.cap, IFluidHandler.FluidAction.EXECUTE);
                if (this.fluid.isEmpty()) {
                    return;
                }
            } else {
                res = acc.drain(new FluidStack(this.fluid, this.cap - this.fluid.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                if (!res.isEmpty()) {
                    this.fluid.grow(res.getAmount());
                }
            }
            if (!(res = acc.drain(new FluidStack(this.fluid, this.cap), IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                this.need = this.cap - res.getAmount();
            }
            this.cont = acc.getContainer();
        });
    }

    public boolean transposing() {
        return this.output ? this.need <= this.cap : this.need >= 0;
    }

    public void readNBT(CompoundNBT nbt) {
        if (this.fixed) {
            this.fluid.setAmount(nbt.func_74762_e("Amount"));
        } else {
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
            this.lock = nbt.func_74767_n("lock") && this.fluid.getRawFluid() != Fluids.field_204541_a;
        }
        this.cont = ItemStack.func_199557_a((CompoundNBT)nbt);
        if (this.cont.func_190916_E() > 0) {
            this.need = this.output ? 0 : this.cap;
        }
    }

    public CompoundNBT writeNBT(CompoundNBT nbt) {
        if (this.fluid.getRawFluid() != Fluids.field_204541_a) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_82580_o("FluidName");
        }
        if (!this.cont.func_190926_b()) {
            this.cont.func_77955_b(nbt);
        } else {
            nbt.func_82580_o("id");
        }
        nbt.func_74757_a("lock", this.lock);
        return nbt;
    }

    public int getComparatorValue() {
        int n = this.fluid.getAmount();
        return n <= 0 ? 0 : (int)((long)n * 14L / (long)this.cap) + 1;
    }
}

