/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class CachedCap<T>
implements NonNullConsumer<LazyOptional<T>>,
Supplier<T> {
    protected final World world;
    protected final BlockPos pos;
    protected final Direction side;
    protected final Capability<T> cap;
    protected final T fallback;
    protected T value;

    public CachedCap(World world, BlockPos pos, Direction side, Capability<T> cap, T fallback) {
        this.fallback = fallback;
        this.cap = cap;
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.value = fallback;
    }

    public void update() {
        if (this.value == this.fallback) {
            this.accept(null);
        }
    }

    public void accept(LazyOptional<T> t) {
        TileEntity te = Utils.getTileAt(this.world, this.pos);
        if (te != null) {
            LazyOptional lo = te.getCapability(this.cap, this.side);
            this.value = lo.orElse(this.fallback);
            if (this.value != this.fallback) {
                lo.addListener((NonNullConsumer)this);
            }
        } else {
            this.value = this.fallback;
        }
    }

    @Override
    public T get() {
        return this.value;
    }
}

