/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.capability.IFluidHandlerModifiable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IMultiFluidHandler
extends IFluidHandlerModifiable {
    public boolean shouldFill(int var1);

    public boolean shouldDrain(int var1);

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int l = this.getTanks();
        for (int i = 0; i < l; ++i) {
            int n;
            if (!this.shouldFill(i) || (n = this.fill(i, resource, action)) <= 0) continue;
            return n;
        }
        return 0;
    }

    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int l = this.getTanks();
        for (int i = 0; i < l; ++i) {
            FluidStack stack;
            if (!this.shouldDrain(i) || !resource.isFluidEqual(this.getFluidInTank(i)) || (stack = this.drain(i, resource.getAmount(), action)).isEmpty()) continue;
            return stack;
        }
        return FluidStack.EMPTY;
    }

    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int l = this.getTanks();
        for (int i = 0; i < l; ++i) {
            FluidStack stack;
            if (!this.shouldDrain(i) || (stack = this.drain(i, maxDrain, action)).isEmpty()) continue;
            return stack;
        }
        return FluidStack.EMPTY;
    }

    default public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack stack = this.getFluidInTank(tank);
        if (stack.isEmpty()) {
            if (!this.isFluidValid(tank, resource)) {
                return 0;
            }
            int max = Math.min(resource.getAmount(), this.getTankCapacity(tank));
            if (action.execute()) {
                this.setFluidInTank(tank, new FluidStack(resource, max));
            }
            return max;
        }
        if (stack.isFluidEqual(resource)) {
            int max = Math.min(resource.getAmount(), this.getTankCapacity(tank) - stack.getAmount());
            if (max <= 0) {
                return 0;
            }
            if (action.execute()) {
                stack.grow(max);
                this.setFluidInTank(tank, stack);
            }
            return max;
        }
        return 0;
    }

    default public FluidStack drain(int tank, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack stack = this.getFluidInTank(tank);
        if ((maxDrain = Math.min(maxDrain, stack.getAmount())) <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack out = new FluidStack(stack, maxDrain);
        if (action.execute()) {
            stack.shrink(maxDrain);
            this.setFluidInTank(tank, stack);
        }
        return out;
    }

    default public IFluidHandler accessTank(final int tank) {
        return new IFluidHandler(){

            public boolean isFluidValid(int t, FluidStack stack) {
                return IMultiFluidHandler.this.isFluidValid(tank, stack);
            }

            public int getTanks() {
                return 1;
            }

            public int getTankCapacity(int t) {
                return IMultiFluidHandler.this.getTankCapacity(tank);
            }

            public FluidStack getFluidInTank(int t) {
                return IMultiFluidHandler.this.getFluidInTank(tank);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return IMultiFluidHandler.this.fill(tank, resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return IMultiFluidHandler.this.drain(tank, maxDrain, action);
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isFluidEqual(IMultiFluidHandler.this.getFluidInTank(tank))) {
                    return IMultiFluidHandler.this.drain(tank, resource.getAmount(), action);
                }
                return FluidStack.EMPTY;
            }
        };
    }
}

