/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.capability;

import cd4017be.lib.capability.IFluidHandlerModifiable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LinkedTank
implements IFluidHandlerModifiable {
    private final Supplier<FluidStack> get;
    private final Consumer<FluidStack> set;
    public int cap;

    public LinkedTank(int cap, Supplier<FluidStack> get, Consumer<FluidStack> set) {
        this.cap = cap;
        this.get = get;
        this.set = set;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.get.get();
    }

    public int getTankCapacity(int tank) {
        return this.cap;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.set.accept(stack);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack res, IFluidHandler.FluidAction action) {
        FluidStack fluid = this.get.get();
        if (fluid.isEmpty()) {
            int m = Math.min(res.getAmount(), this.cap);
            if (action.execute()) {
                this.set.accept(new FluidStack(res, m));
            }
            return m;
        }
        if (fluid.isFluidEqual(res)) {
            int m = Math.min(res.getAmount(), this.cap - fluid.getAmount());
            if (m != 0 && action.execute()) {
                fluid.grow(m);
                this.set.accept(fluid);
            }
            return m;
        }
        return 0;
    }

    public FluidStack drain(FluidStack res, IFluidHandler.FluidAction action) {
        FluidStack fluid = this.get.get();
        if (fluid.isEmpty() || !fluid.isFluidEqual(res)) {
            return FluidStack.EMPTY;
        }
        int m = Math.min(res.getAmount(), fluid.getAmount());
        if (action.execute()) {
            fluid.shrink(m);
            this.set.accept(fluid);
        }
        return new FluidStack(fluid, m);
    }

    public FluidStack drain(int m, IFluidHandler.FluidAction action) {
        FluidStack fluid = this.get.get();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (fluid.getAmount() < m) {
            m = fluid.getAmount();
        }
        if (action.execute()) {
            fluid.shrink(m);
            this.set.accept(fluid);
        }
        return new FluidStack(fluid, m);
    }
}

