/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.config;

import cd4017be.lib.gui.ConfigGui;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfig
implements Supplier<BiFunction<Minecraft, Screen, Screen>> {
    public final ModConfig.Type cfgType;
    public ForgeConfigSpec spec;

    protected ModConfig(ModConfig.Type type) {
        this.cfgType = type;
    }

    protected void finish(ForgeConfigSpec.Builder builder) {
        this.spec = builder.build();
    }

    public void register(String name) {
        ModLoadingContext.get().registerConfig(this.cfgType, this.spec, name + "-" + this.cfgType.name().toLowerCase() + ".toml");
    }

    @Override
    public BiFunction<Minecraft, Screen, Screen> get() {
        return this.spec.isLoaded() ? this::openGui : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openGui(Minecraft mc, Screen parent) {
        if (!this.spec.isLoaded()) {
            return parent;
        }
        return new ConfigGui(parent, (ITextComponent)new StringTextComponent(this.cfgType.name()), this.spec);
    }
}

