/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.container;

import cd4017be.lib.Lib;
import cd4017be.lib.container.IQuickTransferHandler;
import cd4017be.lib.container.slot.HidableSlot;
import cd4017be.lib.container.slot.IFluidSlot;
import cd4017be.lib.container.slot.ISpecialSlot;
import cd4017be.lib.container.slot.SlotArmor;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.StateSyncAdv;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class AdvancedContainer
extends Container
implements IServerPacketReceiver,
IPlayerPacketReceiver {
    protected final StateSyncAdv sync;
    public final PlayerInventory inv;
    protected final int idxCount;
    private int playerInvS;
    private int playerInvE;
    private BitSet syncSlots = new BitSet();
    boolean hardInvUpdate = false;
    public final ArrayList<IQuickTransferHandler> transferHandlers = new ArrayList();

    public AdvancedContainer(ContainerType<?> type, int id, PlayerInventory inv, StateSyncAdv sync, int idxCount) {
        super(type, id);
        this.sync = sync;
        this.inv = inv;
        this.idxCount = idxCount;
    }

    public void func_75132_a(IContainerListener listener) {
        if (listener instanceof ServerPlayerEntity) {
            this.sync.set.set(0);
        }
        super.func_75132_a(listener);
    }

    public void addPlayerInventory(int x, int y) {
        this.addPlayerInventory(x, y, false);
    }

    public void addPlayerInventory(int x, int y, boolean armor) {
        int i;
        this.playerInvS = this.field_75151_b.size();
        this.playerInvE = this.playerInvS + (armor ? 41 : 36);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new HidableSlot((IInventory)this.inv, i * 9 + j + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new HidableSlot((IInventory)this.inv, i, x + i * 18, y + 58));
        }
        if (armor) {
            for (i = 0; i < 4; ++i) {
                this.func_75146_a(new SlotArmor(this.inv, i + 36, x - 18, y - i * 18 + 36, EquipmentSlotType.values()[i + 2]));
            }
            this.func_75146_a(new SlotArmor(this.inv, 40, x - 18, y + 58, EquipmentSlotType.OFFHAND));
        }
    }

    public void addSlot(Slot slot, boolean sync) {
        this.func_75146_a(slot);
        if (sync) {
            int n = this.syncSlots.cardinality();
            if (n < this.idxCount) {
                this.syncSlots.set(slot.field_75222_d);
                this.sync.set(n, slot instanceof IFluidSlot ? FluidStack.EMPTY : ItemStack.field_190927_a);
            } else {
                Lib.LOG.error("Can't add another synced ItemSlot in {}, only {} channels reserved!", this.getClass(), (Object)this.idxCount);
            }
        }
    }

    public void hardInvUpdate() {
        this.hardInvUpdate = true;
    }

    public boolean hasPlayerInv() {
        return this.playerInvS != this.playerInvE;
    }

    public int playerInvStart() {
        return this.playerInvS;
    }

    public boolean func_75135_a(ItemStack item, int ss, int se, boolean d) {
        Slot slot;
        int i;
        ItemStack item1 = item.func_77946_l();
        if (item1.func_77985_e()) {
            for (i = se - ss; i > 0 && item1.func_190916_E() > 0; --i) {
                int mxs;
                slot = (Slot)this.field_75151_b.get(d ? i + ss - 1 : se - i);
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                if (slot instanceof ISpecialSlot) {
                    ISpecialSlot s = (ISpecialSlot)slot;
                    if ((item1 = s.insertItem(item1, false)).func_190926_b()) {
                        item.func_190920_e(0);
                        return true;
                    }
                    if (!s.insertHereOnly(item1)) continue;
                    item.func_190920_e(item1.func_190916_E());
                    return true;
                }
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item1)) continue;
                int j = stack.func_190916_E() + item1.func_190916_E();
                if (j <= (mxs = Math.min(item1.func_77976_d(), slot.func_75219_a()))) {
                    item.func_190920_e(0);
                    stack.func_190920_e(j);
                    slot.func_75218_e();
                    return true;
                }
                if (stack.func_190916_E() >= mxs) continue;
                item1.func_190918_g(mxs - stack.func_190916_E());
                stack.func_190920_e(mxs);
                slot.func_75218_e();
            }
        }
        if (item1.func_190916_E() > 0) {
            for (i = se - ss; i > 0; --i) {
                slot = (Slot)this.field_75151_b.get(d ? i + ss - 1 : se - i);
                if (slot.func_75211_c().func_190916_E() != 0) continue;
                if (slot instanceof ISpecialSlot) {
                    ISpecialSlot s = (ISpecialSlot)slot;
                    if ((item1 = s.insertItem(item1, false)).func_190916_E() == 0) {
                        item.func_190920_e(0);
                        return true;
                    }
                    if (!s.insertHereOnly(item1)) continue;
                    item.func_190920_e(item1.func_190916_E());
                    return true;
                }
                if (!slot.func_75214_a(item1)) continue;
                int mxs = slot.func_178170_b(item1);
                if (item1.func_190916_E() <= mxs) {
                    slot.func_75215_d(item1.func_77946_l());
                    slot.func_75218_e();
                    item.func_190920_e(0);
                    return true;
                }
                slot.func_75215_d(item1.func_77979_a(mxs));
                slot.func_75218_e();
            }
        }
        if (item1.func_190916_E() != item.func_190916_E()) {
            item.func_190920_e(item1.func_190916_E());
            return true;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int id) {
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack item = stack.func_77946_l();
        if (id >= this.playerInvS && id < this.playerInvE) {
            for (IQuickTransferHandler h : this.transferHandlers) {
                if (h.transfer(stack, this)) break;
            }
        } else {
            this.func_75135_a(stack, this.playerInvS, this.playerInvE, false);
        }
        if (stack.func_190916_E() == item.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75220_a(stack, item);
        slot.func_75218_e();
        slot.func_190901_a(player, stack);
        return item;
    }

    public ItemStack func_184996_a(int s, int b, ClickType m, PlayerEntity player) {
        Slot slot;
        Slot slot2 = slot = s >= 0 && s < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(s) : null;
        if (slot instanceof ISpecialSlot) {
            ISpecialSlot ss = (ISpecialSlot)slot;
            return ss.onClick(b, m, player, this);
        }
        return super.func_184996_a(s, b, m, player);
    }

    public void func_75142_b() {
        if (this.hardInvUpdate && this.inv.field_70458_d instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.inv.field_70458_d).field_71137_h = false;
            this.hardInvUpdate = false;
        }
        super.func_75142_b();
        if (this.inv.field_70458_d.field_70170_p.field_72995_K) {
            return;
        }
        this.detectChanges(this.sync.clear());
        this.sync.detectChanges();
        if (!this.sync.isEmpty()) {
            PacketBuffer pkt = GuiNetworkHandler.preparePacket(this);
            this.sync.write((ByteBuf)pkt);
            this.writeChanges(this.sync.set, pkt);
            this.sync.writeChanges(pkt);
            GuiNetworkHandler.GNH_INSTANCE.sendToPlayer(pkt, (ServerPlayerEntity)this.inv.field_70458_d);
        }
    }

    protected void detectChanges(BitSet chng) {
        BitSet slots = this.syncSlots;
        int i = slots.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (slot instanceof IFluidSlot) {
                FluidStack fluidN = ((IFluidSlot)slot).getFluid();
                FluidStack fluidO = (FluidStack)this.sync.get(j);
                if (!fluidO.isFluidStackIdentical(fluidN)) {
                    this.sync.set(j, fluidN.copy());
                }
            } else {
                ItemStack itemN = slot.func_75211_c();
                ItemStack itemO = (ItemStack)this.sync.get(j);
                if (!itemO.equals(itemN, true)) {
                    this.sync.set(j, itemN.func_77946_l());
                }
            }
            i = slots.nextSetBit(i + 1);
            ++j;
        }
    }

    protected void writeChanges(BitSet chng, PacketBuffer pkt) {
        int i0 = this.sync.objIdxOfs();
        int i = chng.nextSetBit(i0);
        while (i > 0 && i - i0 < this.idxCount) {
            Object o = this.sync.get(i - i0);
            if (o instanceof ItemStack) {
                ItemFluidUtil.writeItemHighRes(pkt, (ItemStack)o);
            } else if (o instanceof FluidStack) {
                ItemFluidUtil.writeFluidStack(pkt, (FluidStack)o);
            }
            i = chng.nextSetBit(i + 1);
        }
    }

    protected void readChanges(BitSet chng, PacketBuffer pkt) throws Exception {
        BitSet slots = this.syncSlots;
        int i = slots.nextSetBit(0);
        int j = this.sync.objIdxOfs();
        while (i >= 0) {
            if (chng.get(j)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                if (slot instanceof IFluidSlot) {
                    ((IFluidSlot)slot).putFluid(ItemFluidUtil.readFluidStack(pkt));
                } else {
                    slot.func_75215_d(ItemFluidUtil.readItemHighRes(pkt));
                }
            }
            i = slots.nextSetBit(i + 1);
            ++j;
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (this.syncSlots.get(slotID)) {
            return;
        }
        this.func_75139_a(slotID).func_75215_d(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> items) {
        int m = Math.min(items.size(), this.field_75151_b.size());
        for (int i = 0; i < m; ++i) {
            this.func_75141_a(i, items.get(i));
        }
    }

    @Override
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        this.readChanges(this.sync.read((ByteBuf)pkt), pkt);
        this.sync.readChanges(pkt);
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        for (Object e : this.sync.holders) {
            if (!(e instanceof IPlayerPacketReceiver)) continue;
            ((IPlayerPacketReceiver)e).handlePlayerPacket(pkt, sender);
            return;
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        for (Object e : this.sync.holders) {
            if (!(e instanceof TileEntity)) continue;
            TileEntity te = (TileEntity)e;
            if (te.func_145837_r() || te.func_145831_w() != playerIn.field_70170_p) {
                return false;
            }
            if (te.func_174877_v().func_218137_a((IPosition)playerIn.func_213303_ch(), 8.0)) continue;
            return false;
        }
        return true;
    }

    public BlockPos getPos() {
        for (Object e : this.sync.holders) {
            if (!(e instanceof TileEntity)) continue;
            return ((TileEntity)e).func_174877_v();
        }
        return Utils.NOWHERE;
    }
}

