/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.container;

import cd4017be.api.grid.IGridItem;
import cd4017be.lib.Content;
import cd4017be.lib.Lib;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.container.slot.GlitchSaveSlot;
import cd4017be.lib.gui.ModularGui;
import cd4017be.lib.gui.comp.GuiCompBase;
import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.gui.comp.GuiFrame;
import cd4017be.lib.gui.comp.Progressbar;
import cd4017be.lib.network.StateSyncAdv;
import cd4017be.lib.tileentity.Assembler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class ContainerAssembler
extends AdvancedContainer {
    final Assembler tile;
    private static final ResourceLocation TEX = Lib.rl("textures/gui/assembler.png");

    public ContainerAssembler(int id, PlayerInventory inv, PacketBuffer buf) {
        this(id, inv, null, Assembler.class);
    }

    public ContainerAssembler(int id, PlayerInventory inv, Assembler tile, Object ... toSync) {
        super(Content.aSSEMBLER, id, inv, StateSyncAdv.of(tile == null, StateSyncAdv.array(2, 21), 0, toSync), 0);
        this.tile = tile;
        Object inv1 = tile != null ? tile : new BasicInventory(23);
        this.func_75146_a((Slot)new GlitchSaveSlot((IItemHandler)inv1, 0, 8, 16, false));
        this.func_75146_a((Slot)new GlitchSaveSlot((IItemHandler)inv1, 1, 8, 52, false));
        int k = 2;
        for (int j = 0; j < 3; ++j) {
            int i = 0;
            while (i < 7) {
                this.func_75146_a((Slot)new GlitchSaveSlot((IItemHandler)inv1, k, 44 + i * 18, 16 + j * 18, false));
                ++i;
                ++k;
            }
        }
        this.addPlayerInventory(8, 86);
        this.transferHandlers.add((stack, cont) -> stack.func_77973_b() instanceof IGridItem ? cont.func_75135_a(stack, 2, 23, false) : cont.func_75135_a(stack, 0, 1, false));
    }

    @Override
    protected void detectChanges(BitSet chng) {
        super.detectChanges(chng);
        for (int i = 0; i < 21; ++i) {
            this.sync.setShort(i, this.tile.count(i));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModularGui<ContainerAssembler> setupGui(PlayerInventory inv, ITextComponent name) {
        ModularGui<ContainerAssembler> gui = new ModularGui<ContainerAssembler>(this, inv, name);
        GuiFrame frame = new GuiFrame(gui, 176, 168, 3).title("gui.cd4017be.assembler", 0.5f).background(TEX, 0, 0);
        new Progressbar(frame, 16, 10, 26, 19, 240, 0, 0, this.sync.floatGetter("progressDA", false), 0.0, -1.0);
        new Progressbar(frame, 16, 10, 26, 55, 240, 10, 0, this.sync.floatGetter("progressASS", false), 0.0, -1.0);
        new ItemCounts(frame, 126, 54, 43, 15, this.sync.buffer());
        gui.slotTooltips.put(0, (Object)((Boolean)Lib.CFG_SERVER.canCutBlocks.get() != false ? "gui.cd4017be.destroy" : "gui.cd4017be.destroy_d"));
        gui.slotTooltips.put(1, (Object)((Boolean)Lib.CFG_SERVER.canReplicate.get() != false ? "gui.cd4017be.replicate" : "gui.cd4017be.replicate_d"));
        return gui.setComps(frame, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ItemCounts
    extends GuiCompBase<GuiCompGroup> {
        final ByteBuffer buf;

        public ItemCounts(GuiCompGroup parent, int w, int h, int x, int y, ByteBuffer buf) {
            super(parent, w, h, x, y);
            this.buf = buf.asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public void drawBackground(MatrixStack stack, int mx, int my, float t) {
            this.buf.rewind();
            int x0 = this.x + 17;
            int y0 = this.y + 11;
            for (int y = 0; y < this.h; y += 18) {
                for (int x = 0; x < this.w; x += 18) {
                    short n = this.buf.getShort();
                    if (n > 0) continue;
                    this.drawNumber(stack, x0 + x, y0 + y, n);
                }
            }
        }

        private void drawNumber(MatrixStack stack, int x, int y, int n) {
            char[] symbols = Integer.toString(n).toCharArray();
            x -= symbols.length << 2;
            for (char c : symbols) {
                this.parent.drawRect(stack, x, y, 192 + (c - 48 << 2), 0, 4, 6);
                x += 4;
            }
        }
    }
}

