/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.container;

import cd4017be.lib.Content;
import cd4017be.lib.capability.BasicTanks;
import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.container.ContainerEnergySupply;
import cd4017be.lib.container.slot.SlotFluidHandler;
import cd4017be.lib.gui.ModularGui;
import cd4017be.lib.gui.comp.Button;
import cd4017be.lib.gui.comp.FormatText;
import cd4017be.lib.gui.comp.GuiFrame;
import cd4017be.lib.gui.comp.Slider;
import cd4017be.lib.network.StateSyncAdv;
import cd4017be.lib.tileentity.FluidSupply;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.BitSet;
import java.util.function.DoubleSupplier;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ContainerFluidSupply
extends AdvancedContainer {
    private static final int[] indices = StateSyncAdv.array(8, 12);

    public ContainerFluidSupply(int id, PlayerInventory inv, PacketBuffer pkt) {
        this(id, inv, new BasicTanks(12, 0), true, FluidSupply.class);
    }

    public ContainerFluidSupply(int id, PlayerInventory inv, FluidSupply tile) {
        this(id, inv, tile, false, tile);
    }

    private ContainerFluidSupply(int id, PlayerInventory pinv, IFluidHandler inv, boolean client, Object ... ref) {
        super(Content.fLUID_SUPP, id, pinv, StateSyncAdv.of(client, indices, 12, ref), 12);
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.addSlot(new SlotFluidHandler(inv, i + j * 3, 8 + i * 54, 16 + j * 18), true);
            }
        }
        this.addPlayerInventory(8, 104);
    }

    @Override
    protected void detectChanges(BitSet chng) {
        super.detectChanges(chng);
        FluidSupply tile = (FluidSupply)this.sync.holders[0];
        for (int i = 0; i < 12; ++i) {
            int j = i + tile.scroll;
            if (j < tile.slots.size()) {
                FluidSupply.Slot s = tile.slots.get(j);
                this.sync.setLong(i, (long)s.countIn & 0xFFFFFFFFL | (long)s.countOut << 32);
                continue;
            }
            this.sync.setLong(i, 0L);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModularGui<ContainerFluidSupply> setupGui(PlayerInventory inv, ITextComponent name) {
        DoubleSupplier scroll = this.sync.floatGetter("scroll", true);
        IntBuffer data = ((ByteBuffer)this.sync.buffer().clear()).asIntBuffer();
        ModularGui<ContainerFluidSupply> gui = new ModularGui<ContainerFluidSupply>(this, inv, name);
        GuiFrame frame = new GuiFrame(gui, 186, 186, 25).title("gui.cd4017be.fluid_supp", 0.5f).background(ContainerEnergySupply.TEX, 0, 70);
        new Slider(frame, 8, 12, 70, 170, 16, 176, 0, false, scroll, x -> {
            if ((int)x == (int)scroll.getAsDouble()) {
                return;
            }
            gui.sendPkt((byte)-1, (byte)x);
        }, null, 0.0, FluidSupply.MAX_SLOTS - 12).scroll(-3.0f).tooltip("gui.cd4017be.scroll");
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < 3; ++i) {
                byte k = (byte)(j * 3 + i);
                new FormatText(frame, 36, 16, 24 + i * 54, 16 + j * 18, "\\\u00a72%d\n\u00a74%d", () -> new Object[]{data.get(k << 1), data.get(k << 1 | 1)});
                new Button(frame, 36, 16, 24 + i * 54, 16 + j * 18, 0, null, a -> gui.sendPkt(a == 0 ? k : (byte)(k | 0x10))).tooltip("gui.cd4017be.reset_count");
            }
        }
        return gui.setComps(frame, false);
    }
}

